/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.registry;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.registry.LocalRegistry;

public class LocalRegistryTestCase {
    @Test
    public void test() {
        LocalGroup group = (LocalGroup)Mockito.mock(LocalGroup.class);
        LocalGroupMember localMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        LocalGroupMember nonMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        Map.Entry<String, String> entry = Map.entry("foo", "bar");
        ((LocalGroup)Mockito.doReturn((Object)localMember).when((Object)group)).getLocalMember();
        LocalRegistry registry = LocalRegistry.of((LocalGroup)group, entry, (Runnable)closeTask);
        Assertions.assertThat((Object)registry.getGroup()).isSameAs((Object)group);
        Assertions.assertThat((Object)registry.getEntry(localMember)).isSameAs(entry);
        Assertions.assertThat((Object)registry.getEntry(nonMember)).isNull();
        Assertions.assertThat((Map)registry.getEntries()).containsExactly(new Map.Entry[]{entry});
        Mockito.verifyNoInteractions((Object[])new Object[]{closeTask});
        registry.close();
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        org.junit.jupiter.api.Assertions.assertNull((Object)registry.getEntry(localMember));
        org.junit.jupiter.api.Assertions.assertNull((Object)registry.getEntry(nonMember));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of(), (Object)registry.getEntries());
        registry.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{closeTask});
    }
}

