/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.logging.Logger;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.util.Reference;

public class LocalScheduler<T>
implements Scheduler<T, Instant>,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(LocalScheduler.class);
    private final String name;
    private final ScheduledExecutorService executor;
    private final ScheduledEntries<T, Instant> entries;
    private final Predicate<T> task;
    private final Duration closeTimeout;
    private final Supplier<Map.Entry<Map.Entry<T, Instant>, Future<?>>> schedule;
    private final Supplier<Map.Entry<Map.Entry<T, Instant>, Future<?>>> scheduleIfAbsent;
    private final Reference.Writer<Map.Entry<Map.Entry<T, Instant>, Future<?>>> cancel;
    private final Reference.Writer<Map.Entry<Map.Entry<T, Instant>, Future<?>>> reschedule;

    public LocalScheduler(LocalSchedulerConfiguration<T> configuration) {
        Reference.Writer futureEntryWriter;
        this.name = configuration.getName();
        this.entries = configuration.getScheduledEntries();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, configuration.getThreadFactory());
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(this.entries.isSorted());
        this.executor = executor;
        this.task = configuration.getTask();
        this.closeTimeout = configuration.getCloseTimeout();
        Supplier<Map.Entry> scheduleFirst = this::scheduleFirst;
        UnaryOperator cancel = entry -> {
            ((Future)entry.getValue()).cancel(true);
            return null;
        };
        UnaryOperator reschedule = entry -> {
            cancel.apply(entry);
            return (Map.Entry)scheduleFirst.get();
        };
        Reference futureEntry = Reference.of(null);
        this.schedule = futureEntryWriter = futureEntry.writer(scheduleFirst);
        this.scheduleIfAbsent = futureEntryWriter.when(Objects::isNull);
        this.cancel = futureEntry.writer(cancel);
        this.reschedule = futureEntry.writer(reschedule);
    }

    public void schedule(T id, Instant instant) {
        LOGGER.tracef("Scheduling %s on local %s scheduler for %s", id, (Object)this.name, (Object)instant);
        this.entries.add(id, instant);
        if (this.entries.isSorted()) {
            this.rescheduleIfEarlier(instant);
        }
        this.scheduleIfAbsent();
    }

    public void cancel(T id) {
        LOGGER.tracef("Canceling %s on local %s scheduler", id, (Object)this.name);
        if (this.entries.isSorted()) {
            this.cancelIfPresent(id);
        }
        this.entries.remove(id);
        if (this.entries.isSorted()) {
            this.scheduleIfAbsent();
        }
    }

    public boolean contains(T id) {
        return this.entries.contains(id);
    }

    public void close() {
        LOGGER.debugf("Shutting down local %s scheduler", (Object)this.name);
        this.executor.shutdown();
        if (!this.closeTimeout.isNegative() && !this.closeTimeout.isZero()) {
            try {
                LOGGER.debugf("Waiting for local %s scheduler tasks to complete", (Object)this.name);
                this.executor.awaitTermination(this.closeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.debugf("Local %s scheduler shutdown complete", (Object)this.name);
    }

    @Override
    public void run() {
        Iterator<Map.Entry<T, Instant>> entries = this.entries.iterator();
        while (entries.hasNext()) {
            if (Thread.currentThread().isInterrupted() || this.executor.isShutdown()) {
                return;
            }
            Map.Entry<T, Instant> entry = entries.next();
            if (entry.getValue().isAfter(Instant.now())) break;
            T key = entry.getKey();
            LOGGER.tracef("Executing task for %s on local %s scheduler", key, (Object)this.name);
            if (!this.task.test(key)) continue;
            entries.remove();
        }
        this.schedule.get();
    }

    private Map.Entry<Map.Entry<T, Instant>, Future<?>> scheduleFirst() {
        Map.Entry<T, Instant> entry = this.entries.peek();
        return entry != null ? this.schedule(entry) : null;
    }

    private Map.Entry<Map.Entry<T, Instant>, Future<?>> schedule(Map.Entry<T, Instant> entry) {
        Duration delay = Duration.between(Instant.now(), entry.getValue());
        long millis = !delay.isNegative() ? delay.toMillis() + 1L : 0L;
        try {
            ScheduledFuture<?> future = this.executor.schedule(this, millis, TimeUnit.MILLISECONDS);
            return Map.entry(entry, future);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    private void scheduleIfAbsent() {
        this.scheduleIfAbsent.get();
    }

    private void rescheduleIfEarlier(Instant instant) {
        this.reschedule.when(entry -> entry != null && instant.isBefore((Instant)((Map.Entry)entry.getKey()).getValue())).get();
    }

    private void cancelIfPresent(T id) {
        this.cancel.when(entry -> entry != null && ((Map.Entry)entry.getKey()).getKey().equals(id)).get();
    }

    public String toString() {
        return this.entries.toString();
    }
}

