/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.provider;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.local.LocalGroup;
import org.wildfly.clustering.server.local.LocalGroupMember;
import org.wildfly.clustering.server.local.provider.LocalServiceProviderRegistrar;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;

public class LocalServiceProviderRegistrarTestCase {
    @Test
    public void test() {
        LocalGroup group = (LocalGroup)Mockito.mock(LocalGroup.class);
        LocalGroupMember localMember = (LocalGroupMember)Mockito.mock(LocalGroupMember.class);
        ((LocalGroup)Mockito.doReturn((Object)localMember).when((Object)group)).getLocalMember();
        LocalServiceProviderRegistrar registrar = LocalServiceProviderRegistrar.of((LocalGroup)group);
        Assertions.assertThat((Object)registrar.getGroup()).isSameAs((Object)group);
        Assertions.assertThat((Collection)registrar.getServices()).isEmpty();
        Assertions.assertThat((Collection)registrar.getProviders((Object)"foo")).isEmpty();
        Assertions.assertThat((Collection)registrar.getProviders((Object)"bar")).isEmpty();
        ServiceProviderRegistration foo = registrar.register((Object)"foo");
        Assertions.assertThat((String)((String)foo.getService())).isEqualTo("foo");
        Assertions.assertThat((Collection)foo.getProviders()).containsExactly((Object[])new LocalGroupMember[]{localMember});
        Assertions.assertThat((Collection)registrar.getServices()).containsExactly((Object[])new String[]{"foo"});
        Assertions.assertThat((Collection)registrar.getProviders((Object)"foo")).containsExactly((Object[])new LocalGroupMember[]{localMember});
        Assertions.assertThat((Collection)registrar.getProviders((Object)"bar")).isEmpty();
        ServiceProviderRegistration bar = registrar.register((Object)"bar");
        Assertions.assertThat((String)((String)bar.getService())).isEqualTo("bar");
        Assertions.assertThat((Collection)bar.getProviders()).containsExactly((Object[])new LocalGroupMember[]{localMember});
        Assertions.assertThat((Collection)registrar.getServices()).containsExactlyInAnyOrder((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((Collection)registrar.getProviders((Object)"foo")).containsExactly((Object[])new LocalGroupMember[]{localMember});
        Assertions.assertThat((Collection)registrar.getProviders((Object)"bar")).containsExactly((Object[])new LocalGroupMember[]{localMember});
        foo.close();
        Assertions.assertThat((Collection)registrar.getServices()).containsExactly((Object[])new String[]{"bar"});
        Assertions.assertThat((Collection)registrar.getProviders((Object)"foo")).isEmpty();
        Assertions.assertThat((Collection)registrar.getProviders((Object)"bar")).containsExactly((Object[])new LocalGroupMember[]{localMember});
        bar.close();
        Assertions.assertThat((Collection)registrar.getServices()).isEmpty();
        Assertions.assertThat((Collection)registrar.getProviders((Object)"foo")).isEmpty();
        Assertions.assertThat((Collection)registrar.getProviders((Object)"bar")).isEmpty();
    }
}

