/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerService;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;

public class LocalSchedulerServiceTestCase {
    static LocalSchedulerService.Configuration<UUID> configuration(final ScheduledEntries<UUID, Instant> entries, final Predicate<UUID> task) {
        return new LocalSchedulerService.Configuration<UUID>(){

            public String getName() {
                return "test";
            }

            public ScheduledEntries<UUID, Instant> getScheduledEntries() {
                return entries;
            }

            public Predicate<UUID> getTask() {
                return task;
            }

            public ThreadFactory getThreadFactory() {
                return Thread::new;
            }

            public Duration getCloseTimeout() {
                return Duration.ZERO;
            }
        };
    }

    @Test
    public void lifecycle() {
        ScheduledEntries entries = ScheduledEntries.queued();
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalSchedulerService scheduler = new LocalSchedulerService(LocalSchedulerServiceTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, (Predicate<UUID>)task));){
            Mockito.when((Object)task.test((Object)entry.getKey())).thenReturn((Object)true);
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            LocalSchedulerServiceTestCase.waitUntilEmpty((ScheduledEntries<UUID, Instant>)entries);
            Mockito.verifyNoInteractions((Object[])new Object[]{task});
            Assertions.assertThat((Iterable)entries).isNotEmpty();
            scheduler.start();
            LocalSchedulerServiceTestCase.waitUntilEmpty((ScheduledEntries<UUID, Instant>)entries);
            ((Predicate)Mockito.verify((Object)task)).test((Object)entry.getKey());
            Assertions.assertThat((Iterable)entries).isEmpty();
        }
    }

    @Test
    public void successfulTask() {
        ScheduledEntries entries = ScheduledEntries.queued();
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalSchedulerService scheduler = new LocalSchedulerService(LocalSchedulerServiceTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, (Predicate<UUID>)task));){
            scheduler.start();
            Mockito.when((Object)task.test((Object)entry.getKey())).thenReturn((Object)true);
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            LocalSchedulerServiceTestCase.waitUntilEmpty((ScheduledEntries<UUID, Instant>)entries);
            Assertions.assertThat((Iterable)entries).isEmpty();
            ((Predicate)Mockito.verify((Object)task)).test((Object)entry.getKey());
        }
    }

    @Test
    public void failingTask() {
        ScheduledEntries entries = ScheduledEntries.queued();
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalSchedulerService scheduler = new LocalSchedulerService(LocalSchedulerServiceTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, (Predicate<UUID>)task));){
            scheduler.start();
            Mockito.when((Object)task.test((Object)entry.getKey())).thenReturn((Object)false);
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            LocalSchedulerServiceTestCase.waitUntilEmpty((ScheduledEntries<UUID, Instant>)entries);
            Assertions.assertThat((Iterable)entries).isNotEmpty();
            ((Predicate)Mockito.verify((Object)task, (VerificationMode)Mockito.atLeastOnce())).test((Object)entry.getKey());
        }
    }

    @Test
    public void retryUntilSuccessfulTask() {
        ScheduledEntries entries = ScheduledEntries.queued();
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalSchedulerService scheduler = new LocalSchedulerService(LocalSchedulerServiceTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, (Predicate<UUID>)task));){
            scheduler.start();
            Mockito.when((Object)task.test((Object)entry.getKey())).thenReturn((Object)false, (Object[])new Boolean[]{true});
            scheduler.schedule((Object)entry.getKey(), (Object)entry.getValue());
            LocalSchedulerServiceTestCase.waitUntilEmpty((ScheduledEntries<UUID, Instant>)entries);
            Assertions.assertThat((Iterable)entries).isEmpty();
            ((Predicate)Mockito.verify((Object)task, (VerificationMode)Mockito.times((int)2))).test((Object)entry.getKey());
        }
    }

    @Test
    public void cancel() {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        Map.Entry<UUID, Instant> entry = Map.entry(UUID.randomUUID(), Instant.now());
        try (LocalSchedulerService scheduler = new LocalSchedulerService(LocalSchedulerServiceTestCase.configuration((ScheduledEntries<UUID, Instant>)entries, (Predicate<UUID>)task));){
            Mockito.when((Object)entries.peek()).thenReturn(entry);
            scheduler.cancel((Object)entry.getKey());
            ((ScheduledEntries)Mockito.verify((Object)entries)).remove((Object)entry.getKey());
        }
    }

    private static void waitUntilEmpty(ScheduledEntries<UUID, Instant> entries) {
        Instant stop = Instant.now().plus(Duration.ofSeconds(1L));
        while (entries.peek() != null && Instant.now().isBefore(stop)) {
            Thread.yield();
        }
    }
}

