/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.UnaryOperator;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.SchedulerService;
import org.wildfly.clustering.server.service.SimpleService;
import org.wildfly.clustering.server.util.BlockingReference;

public class LocalSchedulerService<K>
extends SimpleService
implements SchedulerService<K, Instant>,
Runnable {
    private static final System.Logger LOGGER = System.getLogger(LocalSchedulerService.class.getName());
    private final String name;
    private final ScheduledExecutorService executor;
    private final ScheduledEntries<K, Instant> entries;
    private final Predicate<K> task;
    private final Duration closeTimeout;
    private final org.wildfly.clustering.function.Supplier<Map.Entry<Map.Entry<K, Instant>, Future<?>>> schedule;
    private final org.wildfly.clustering.function.Supplier<Map.Entry<Map.Entry<K, Instant>, Future<?>>> scheduleIfAbsent;
    private final BlockingReference.Writer<Map.Entry<Map.Entry<K, Instant>, Future<?>>> cancel;
    private final BlockingReference.Writer<Map.Entry<Map.Entry<K, Instant>, Future<?>>> reschedule;

    public LocalSchedulerService(Configuration<K> configuration) {
        BlockingReference.Writer futureEntryWriter;
        this.name = configuration.getName();
        this.entries = configuration.getScheduledEntries();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, configuration.getThreadFactory());
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(this.entries.isSorted());
        this.executor = executor;
        this.task = configuration.getTask();
        this.closeTimeout = configuration.getCloseTimeout();
        org.wildfly.clustering.function.Supplier scheduleFirst = this::scheduleFirst;
        Consumer cancelFuture = future -> future.cancel(true);
        Consumer cancelEntry = cancelFuture.compose(Map.Entry::getValue).when(Objects::nonNull);
        UnaryOperator cancel = UnaryOperator.of((java.util.function.Consumer)cancelEntry, (Supplier)org.wildfly.clustering.function.Supplier.of(null));
        UnaryOperator reschedule = UnaryOperator.of((java.util.function.Consumer)cancelEntry, (Supplier)scheduleFirst);
        BlockingReference futureEntry = BlockingReference.of(null);
        this.schedule = futureEntryWriter = futureEntry.writer((Supplier)scheduleFirst);
        this.scheduleIfAbsent = futureEntryWriter.when(Objects::isNull);
        this.cancel = futureEntry.writer(cancel);
        this.reschedule = futureEntry.writer(reschedule);
    }

    public void schedule(K key, Instant instant) {
        LOGGER.log(System.Logger.Level.TRACE, "Scheduling {1} on local {0} scheduler for {2}", this.name, key, instant);
        this.entries.add(key, instant);
        if (this.entries.isSorted()) {
            this.rescheduleIfEarlier(instant);
        }
        this.scheduleIfAbsent();
    }

    public void cancel(K key) {
        LOGGER.log(System.Logger.Level.TRACE, "Canceling {1} on local {0} scheduler", this.name, key);
        if (this.entries.isSorted()) {
            this.cancelIfPresent(key);
        }
        this.entries.remove(key);
        if (this.entries.isSorted()) {
            this.scheduleIfAbsent();
        }
    }

    public boolean contains(K key) {
        return this.entries.contains(key);
    }

    public void start() {
        super.start();
        this.schedule.get();
    }

    public void stop() {
        this.cancel.get();
        super.stop();
    }

    public void close() {
        LOGGER.log(System.Logger.Level.DEBUG, "Shutting down local {0} scheduler", this.name);
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LocalSchedulerService.this.executor.shutdown();
                return null;
            }
        };
        AccessController.doPrivileged(action);
        if (!this.closeTimeout.isNegative() && !this.closeTimeout.isZero()) {
            try {
                LOGGER.log(System.Logger.Level.DEBUG, "Waiting for local {0} scheduler tasks to complete", this.name);
                this.executor.awaitTermination(this.closeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.log(System.Logger.Level.DEBUG, "Local {0} scheduler shutdown complete", this.name);
    }

    @Override
    public void run() {
        Iterator<Map.Entry<K, Instant>> entries = this.entries.iterator();
        while (entries.hasNext()) {
            if (Thread.currentThread().isInterrupted() || this.executor.isShutdown()) {
                return;
            }
            Map.Entry<K, Instant> entry = entries.next();
            if (entry.getValue().isAfter(Instant.now())) break;
            K key = entry.getKey();
            LOGGER.log(System.Logger.Level.DEBUG, "Executing task for {1} on local {0} scheduler", this.name, key);
            if (!this.task.test(key)) continue;
            entries.remove();
        }
        this.schedule.get();
    }

    private Map.Entry<Map.Entry<K, Instant>, Future<?>> scheduleFirst() {
        Map.Entry<K, Instant> entry = this.entries.peek();
        return entry != null ? this.scheduleEntry(entry) : null;
    }

    private Map.Entry<Map.Entry<K, Instant>, Future<?>> scheduleEntry(Map.Entry<K, Instant> entry) {
        Instant target;
        if (!this.isStarted()) {
            return null;
        }
        Instant now = Instant.now();
        Duration delay = now.isBefore(target = entry.getValue()) ? Duration.between(now, target) : Duration.ZERO;
        try {
            ScheduledFuture<?> future = this.executor.schedule(this, delay.toNanos(), TimeUnit.NANOSECONDS);
            return Map.entry(entry, future);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    private void scheduleIfAbsent() {
        this.scheduleIfAbsent.get();
    }

    private void rescheduleIfEarlier(Instant instant) {
        this.reschedule.when(entry -> entry != null && instant.isBefore((Instant)((Map.Entry)entry.getKey()).getValue())).get();
    }

    private void cancelIfPresent(K id) {
        this.cancel.when(entry -> entry != null && ((Map.Entry)entry.getKey()).getKey().equals(id)).get();
    }

    public String toString() {
        return this.entries.toString();
    }

    public static interface Configuration<K> {
        public String getName();

        default public ScheduledEntries<K, Instant> getScheduledEntries() {
            return ScheduledEntries.sorted();
        }

        public Predicate<K> getTask();

        public ThreadFactory getThreadFactory();

        default public Duration getCloseTimeout() {
            return Duration.ZERO;
        }
    }
}

