/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.expiration;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;

public class ExpirationMetaDataTestCase {
    @Test
    public void nullTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return null;
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assertions.assertFalse((boolean)metaData.isExpired());
        Assertions.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void negativeTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofSeconds(-1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assertions.assertFalse((boolean)metaData.isExpired());
        Assertions.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void zeroTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ZERO;
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assertions.assertFalse((boolean)metaData.isExpired());
        Assertions.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void expired() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofMinutes(1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now().minus(Duration.ofHours(1L));
            }
        };
        Assertions.assertTrue((boolean)metaData.isExpired());
        Assertions.assertFalse((boolean)metaData.isImmortal());
    }

    @Test
    public void notYetExpired() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofHours(1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now();
            }
        };
        Assertions.assertFalse((boolean)metaData.isExpired());
        Assertions.assertFalse((boolean)metaData.isImmortal());
    }
}

