/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.context;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.wildfly.clustering.server.context.Context;
import org.wildfly.clustering.server.context.ContextFactory;

public enum ContextStrategy implements ContextFactory
{
    UNSHARED{

        @Override
        public <K, V> Context<K, V> createContext(final Consumer<V> startTask, final Consumer<V> stopTask) {
            return new Context<K, V>(){

                @Override
                public V computeIfAbsent(K key, BiFunction<K, Runnable, V> factory) {
                    AtomicReference reference = new AtomicReference();
                    Object value = factory.apply(key, () -> Optional.ofNullable(reference.getPlain()).ifPresent(stopTask::accept));
                    if (value != null) {
                        startTask.accept(value);
                        reference.setPlain(value);
                    }
                    return value;
                }
            };
        }
    }
    ,
    SHARED{

        @Override
        public <K, V> Context<K, V> createContext(final Consumer<V> startTask, final Consumer<V> stopTask) {
            final BiFunction addFunction = new BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>>(){

                @Override
                public Map.Entry<Integer, AtomicReference<V>> apply(K id, Map.Entry<Integer, AtomicReference<V>> entry) {
                    return entry != null ? Map.entry(entry.getKey() + 1, entry.getValue()) : Map.entry(0, new AtomicReference());
                }
            };
            final BiFunction removeFunction = new BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>>(){

                @Override
                public Map.Entry<Integer, AtomicReference<V>> apply(K key, Map.Entry<Integer, AtomicReference<V>> entry) {
                    AtomicReference reference;
                    int count = entry != null ? entry.getKey() : 0;
                    AtomicReference atomicReference = reference = entry != null ? entry.getValue() : null;
                    if (count == 0) {
                        Optional.ofNullable(reference).map(AtomicReference::getPlain).ifPresent(stopTask::accept);
                        return null;
                    }
                    return Map.entry(count - 1, reference);
                }
            };
            return new Context<K, V>(){
                private final Map<K, Map.Entry<Integer, AtomicReference<V>>> entries = new ConcurrentHashMap();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V computeIfAbsent(K key, BiFunction<K, Runnable, V> factory) {
                    Map.Entry entry = this.entries.compute(key, addFunction);
                    AtomicReference reference = entry.getValue();
                    if (reference.getPlain() == null) {
                        AtomicReference atomicReference = reference;
                        synchronized (atomicReference) {
                            if (reference.getPlain() == null) {
                                Runnable closeTask = () -> this.entries.compute(key, removeFunction);
                                Object value = factory.apply(key, closeTask);
                                if (value != null) {
                                    startTask.accept(value);
                                    reference.setPlain(value);
                                } else {
                                    closeTask.run();
                                }
                            }
                        }
                    }
                    return reference.get();
                }
            };
        }
    };

}

