/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.offset;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.Offset;

public class OffsetTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Offset offset = Offset.forDuration((Duration)Duration.ZERO);
        Assertions.assertSame((Object)backward, (Object)offset.apply((Object)backward));
        Assertions.assertSame((Object)Duration.ZERO, (Object)offset.apply((Object)Duration.ZERO));
        Assertions.assertSame((Object)forward, (Object)offset.apply((Object)forward));
        offset = Offset.forDuration((Duration)forward);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)offset.apply((Object)backward));
        Assertions.assertEquals((Object)forward, (Object)offset.apply((Object)Duration.ZERO));
        offset = Offset.forDuration((Duration)backward);
        Assertions.assertEquals((Object)backward, (Object)offset.apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)offset.apply((Object)forward));
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        Offset offset = Offset.forInstant((Duration)Duration.ZERO);
        Assertions.assertSame((Object)past, (Object)offset.apply((Object)past));
        Assertions.assertSame((Object)present, (Object)offset.apply((Object)present));
        Assertions.assertSame((Object)future, (Object)offset.apply((Object)future));
        offset = Offset.forInstant((Duration)forward);
        Assertions.assertEquals((Object)present, (Object)offset.apply((Object)past));
        Assertions.assertEquals((Object)future, (Object)offset.apply((Object)present));
        offset = Offset.forInstant((Duration)backward);
        Assertions.assertEquals((Object)past, (Object)offset.apply((Object)present));
        Assertions.assertEquals((Object)present, (Object)offset.apply((Object)future));
    }
}

