/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.offset;

import java.time.Duration;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.OffsetValue;

public class OffsetValueTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        OffsetValue value = OffsetValue.from((Duration)Duration.ZERO);
        Assertions.assertTrue((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assertions.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertSame((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)forward);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assertions.assertEquals((Object)forward, (Object)value.get());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)backward));
        Assertions.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        OffsetValue rebaseValue = value.rebase();
        Assertions.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assertions.assertEquals((Object)forward, (Object)rebaseValue.getBasis());
        Assertions.assertEquals((Object)forward, (Object)rebaseValue.get());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)rebaseValue.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)forward, (Object)rebaseValue.getOffset().apply((Object)forward));
        value.set((Object)backward);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assertions.assertEquals((Object)backward, (Object)value.get());
        Assertions.assertEquals((Object)backward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)forward));
        Assertions.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assertions.assertEquals((Object)value.get(), (Object)rebaseValue.getBasis());
        Assertions.assertEquals((Object)value.get(), (Object)rebaseValue.get());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)rebaseValue.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)forward, (Object)rebaseValue.getOffset().apply((Object)forward));
        value = OffsetValue.from((Duration)forward);
        Assertions.assertTrue((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)forward, (Object)value.getBasis());
        Assertions.assertSame((Object)forward, (Object)value.get());
        Assertions.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)Duration.ZERO);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)forward, (Object)value.getBasis());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assertions.assertEquals((Object)backward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)forward));
        value = OffsetValue.from((Duration)backward);
        Assertions.assertTrue((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)backward, (Object)value.getBasis());
        Assertions.assertSame((Object)backward, (Object)value.get());
        Assertions.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assertions.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)Duration.ZERO);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)backward, (Object)value.getBasis());
        Assertions.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assertions.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)backward));
        Assertions.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)Duration.ZERO));
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        OffsetValue value = OffsetValue.from((Instant)present);
        Assertions.assertTrue((boolean)value.getOffset().isZero());
        Assertions.assertSame((Object)present, (Object)value.getBasis());
        Assertions.assertSame((Object)present, (Object)value.get());
        Assertions.assertSame((Object)past, (Object)value.getOffset().apply((Object)past));
        Assertions.assertSame((Object)present, (Object)value.getOffset().apply((Object)present));
        Assertions.assertSame((Object)future, (Object)value.getOffset().apply((Object)future));
        value.set((Object)future);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertEquals((Object)present, (Object)value.getBasis());
        Assertions.assertEquals((Object)future, (Object)value.get());
        Assertions.assertEquals((Object)present, (Object)value.getOffset().apply((Object)past));
        Assertions.assertEquals((Object)future, (Object)value.getOffset().apply((Object)present));
        OffsetValue rebaseValue = value.rebase();
        Assertions.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assertions.assertEquals((Object)future, (Object)rebaseValue.getBasis());
        Assertions.assertEquals((Object)future, (Object)rebaseValue.get());
        Assertions.assertSame((Object)past, (Object)rebaseValue.getOffset().apply((Object)past));
        Assertions.assertSame((Object)present, (Object)rebaseValue.getOffset().apply((Object)present));
        Assertions.assertSame((Object)future, (Object)rebaseValue.getOffset().apply((Object)future));
        value.set((Object)past);
        Assertions.assertFalse((boolean)value.getOffset().isZero());
        Assertions.assertEquals((Object)present, (Object)value.getBasis());
        Assertions.assertEquals((Object)past, (Object)value.get());
        Assertions.assertEquals((Object)past, (Object)value.getOffset().apply((Object)present));
        Assertions.assertEquals((Object)present, (Object)value.getOffset().apply((Object)future));
        Assertions.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assertions.assertEquals((Object)past, (Object)rebaseValue.getBasis());
        Assertions.assertEquals((Object)past, (Object)rebaseValue.get());
        Assertions.assertSame((Object)past, (Object)rebaseValue.getOffset().apply((Object)past));
        Assertions.assertSame((Object)present, (Object)rebaseValue.getOffset().apply((Object)present));
        Assertions.assertSame((Object)future, (Object)rebaseValue.getOffset().apply((Object)future));
    }
}

