/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.offset;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.Offset;

public class OffsetTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Offset offset = Offset.forDuration((Duration)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)backward))).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)Duration.ZERO))).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)forward))).isSameAs((Object)forward);
        offset = Offset.forDuration((Duration)forward);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)backward))).isZero();
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)Duration.ZERO))).isEqualTo((Object)forward);
        offset = Offset.forDuration((Duration)backward);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)Duration.ZERO))).isEqualTo((Object)backward);
        Assertions.assertThat((Duration)((Duration)offset.apply((Object)forward))).isZero();
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        Offset offset = Offset.forInstant((Duration)Duration.ZERO);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)past))).isSameAs((Object)past);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)present))).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)future))).isSameAs((Object)future);
        offset = Offset.forInstant((Duration)forward);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)past))).isEqualTo((Object)present);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)present))).isEqualTo((Object)future);
        offset = Offset.forInstant((Duration)backward);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)present))).isEqualTo((Object)past);
        Assertions.assertThat((Instant)((Instant)offset.apply((Object)future))).isEqualTo((Object)present);
    }
}

