/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ReadableReference<T> {
    public Reader<T> reader();

    public static class ReferenceReader<T, V>
    implements Reader<V> {
        private final StampedLock lock;
        private final Supplier<T> reader;
        private final Function<T, V> mapper;

        ReferenceReader(StampedLock lock, Supplier<T> reader, Function<T, V> mapper) {
            this.lock = lock;
            this.reader = reader;
            this.mapper = mapper;
        }

        @Override
        public <R> Reader<R> map(Function<V, R> mapper) {
            return new ReferenceReader<T, R>(this.lock, this.reader, this.mapper.andThen(mapper));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Consumer<V> consumer) {
            long stamp = this.lock.readLock();
            try {
                T value = this.reader.get();
                V result = this.mapper.apply(value);
                consumer.accept(result);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            Object value = null;
            V result = null;
            long stamp = this.lock.tryOptimisticRead();
            try {
                if (StampedLock.isOptimisticReadStamp(stamp)) {
                    value = this.reader.get();
                    result = this.mapper.apply(value);
                }
                if (!this.lock.validate(stamp)) {
                    stamp = this.lock.readLock();
                    value = this.reader.get();
                    result = this.mapper.apply(value);
                }
                V v = result;
                return v;
            }
            finally {
                if (StampedLock.isReadLockStamp(stamp)) {
                    this.lock.unlockRead(stamp);
                }
            }
        }
    }

    public static interface Reader<T>
    extends Supplier<T> {
        public void consume(Consumer<T> var1);

        public <R> Reader<R> map(Function<T, R> var1);
    }
}

