/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.util.Reference;

public class ReferenceTestCase {
    private static final int ITERATIONS = 1000;
    private static final int CONCURRENCY = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws ExecutionException {
        int expected = 0;
        Random random = new Random();
        Reference reference = Reference.of((Object)0);
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(1000);
        for (int i = 0; i < 1000; ++i) {
            int increment = random.nextInt(0, 10);
            expected += increment;
            Reference.Writer writer = reference.writer(value -> value + increment);
            tasks.add(() -> writer.get());
        }
        ExecutorService executor = Executors.newFixedThreadPool(100);
        try {
            ArrayList futures = new ArrayList(1000);
            for (Runnable runnable : tasks) {
                futures.add(executor.submit(runnable));
            }
            for (Future future : futures) {
                future.get();
            }
            Assertions.assertThat((Integer)((Integer)reference.reader().get())).isEqualTo(expected);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            executor.shutdown();
        }
    }
}

