/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.server.util.ReadableReference;
import org.wildfly.clustering.server.util.Reference;

public interface ReferenceMap<K, V>
extends ReadableReference<Map<K, V>> {
    public Reference<V> reference(K var1);

    public static <K, V> ReferenceMap<K, V> of(final Map<K, V> map) {
        final StampedLock lock = new StampedLock();
        final Supplier<Map> reader = () -> Collections.unmodifiableMap(map);
        final UnaryOperator mapper = UnaryOperator.identity();
        return new ReferenceMap<K, V>(){

            @Override
            public Reference<V> reference(K key) {
                final Supplier<Object> reader2 = () -> map.get(key);
                final Consumer<Object> writer = value -> map.put(key, value);
                final UnaryOperator mapper2 = UnaryOperator.identity();
                return new Reference<V>(){

                    @Override
                    public ReadableReference.Reader<V> reader() {
                        return new ReadableReference.ReferenceReader(lock, reader2, mapper2);
                    }

                    @Override
                    public Reference.Writer<V> writer(UnaryOperator<V> updater) {
                        return new Reference.ReferenceWriter(lock, reader2, writer, mapper2, updater);
                    }
                };
            }

            @Override
            public ReadableReference.Reader<Map<K, V>> reader() {
                return new ReadableReference.ReferenceReader(lock, reader, mapper);
            }
        };
    }
}

