/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.cache;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.UnaryOperator;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheStrategy implements CacheFactory
{
    NONE{

        @Override
        public <K, V> Cache<K, V> createCache(final Consumer<V> startTask, final Consumer<V> stopTask) {
            return new Cache<K, V>(){

                @Override
                public V computeIfAbsent(K key, BiFunction<K, java.lang.Runnable, V> factory) {
                    AtomicReference reference = new AtomicReference();
                    Object value = factory.apply(key, () -> Optional.ofNullable(reference.getPlain()).ifPresent(stopTask::accept));
                    if (value != null) {
                        startTask.accept(value);
                        reference.setPlain(value);
                    }
                    return value;
                }
            };
        }
    }
    ,
    CONCURRENT{

        @Override
        public <K, V> Cache<K, V> createCache(final Consumer<V> startTask, final Consumer<V> stopTask) {
            final PutOrIncrementFunction addLockFunction = new PutOrIncrementFunction(Map::entry, StampedLock::new);
            final RemoveOrDecrementFunction removeLockFunction = new RemoveOrDecrementFunction(Map::entry);
            final PutOrIncrementFunction addReferenceFunction = new PutOrIncrementFunction(AbstractMap.SimpleEntry::new, AtomicReference::new);
            final RemoveOrDecrementFunction removeReferenceFunction = new RemoveOrDecrementFunction(AbstractMap.SimpleEntry::new);
            return new Cache<K, V>(){
                private final Map<K, Map.Entry<Integer, StampedLock>> locks = new ConcurrentHashMap();
                private final Map<K, Map.Entry<Integer, AtomicReference<V>>> references = new ConcurrentHashMap();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V computeIfAbsent(K key, BiFunction<K, java.lang.Runnable, V> factory) {
                    Object result = null;
                    StampedLock lock = this.locks.compute(key, addLockFunction).getValue();
                    AtomicReference reference = this.references.compute(key, addReferenceFunction).getValue();
                    long stamp = lock.tryOptimisticRead();
                    try {
                        Runnable stop;
                        Object v = result = StampedLock.isOptimisticReadStamp(stamp) ? (Object)reference.getPlain() : null;
                        if (!lock.validate(stamp)) {
                            stamp = lock.readLock();
                            result = reference.getPlain();
                        }
                        if (result == null) {
                            long conversionStamp = lock.tryConvertToWriteLock(stamp);
                            if (StampedLock.isWriteLockStamp(conversionStamp)) {
                                stamp = conversionStamp;
                            } else {
                                if (StampedLock.isReadLockStamp(stamp)) {
                                    lock.unlockRead(stamp);
                                }
                                stamp = lock.writeLock();
                            }
                            result = reference.getPlain();
                        }
                        if (result == null && (result = (Object)factory.apply(key, () -> this.lambda$computeIfAbsent$1(key, stop = () -> {
                            long stopStamp = lock.writeLock();
                            try {
                                Object value = reference.getPlain();
                                if (value != null) {
                                    stopTask.accept(value);
                                    reference.setPlain(null);
                                }
                            }
                            finally {
                                lock.unlockWrite(stopStamp);
                            }
                        }))) != null) {
                            startTask.accept(result);
                            reference.setPlain(result);
                        }
                        Object v2 = result;
                        return v2;
                    }
                    finally {
                        if (StampedLock.isLockStamp(stamp)) {
                            lock.unlock(stamp);
                        }
                        if (result == null) {
                            this.remove(key, (java.lang.Runnable)Runnable.empty());
                        }
                    }
                }

                private void remove(K key, java.lang.Runnable stopTask2) {
                    if (this.references.compute(key, removeReferenceFunction) == null) {
                        stopTask2.run();
                    }
                    this.locks.compute(key, removeLockFunction);
                }

                private /* synthetic */ void lambda$computeIfAbsent$1(Object key, Runnable stop) {
                    this.remove(key, (java.lang.Runnable)stop);
                }
            };
        }
    };


    private static class RemoveOrDecrementFunction<K, V>
    extends AbstractFunction<K, V> {
        private static final UnaryOperator<Integer> DECREMENT = Math::decrementExact;
        private static final UnaryOperator<Integer> REMOVE_OR_DECREMENT = DECREMENT.orDefault(NOT_NULL.and(Predicate.not(INITIAL_INDEX::equals)), (Supplier)org.wildfly.clustering.function.Supplier.of(null));

        RemoveOrDecrementFunction(BiFunction<Integer, V, Map.Entry<Integer, V>> entryFactory) {
            super(entryFactory, REMOVE_OR_DECREMENT, UnaryOperator.identity());
        }
    }

    private static class PutOrIncrementFunction<K, V>
    extends AbstractFunction<K, V> {
        private static final UnaryOperator<Integer> INCREMENT = Math::incrementExact;
        private static final UnaryOperator<Integer> PUT_OR_INCREMENT = INCREMENT.orDefault(NOT_NULL, (Supplier)org.wildfly.clustering.function.Supplier.of((Object)INITIAL_INDEX));

        PutOrIncrementFunction(BiFunction<Integer, V, Map.Entry<Integer, V>> entryFactory, org.wildfly.clustering.function.Supplier<V> factory) {
            super(entryFactory, PUT_OR_INCREMENT, UnaryOperator.identity().orDefault(Objects::nonNull, factory));
        }
    }

    private static class AbstractFunction<K, V>
    implements BiFunction<K, Map.Entry<Integer, V>, Map.Entry<Integer, V>> {
        static final Predicate<Integer> NOT_NULL = Objects::nonNull;
        static final Integer INITIAL_INDEX = 0;
        private final BiFunction<Integer, V, Map.Entry<Integer, V>> entryFactory;
        private final UnaryOperator<Integer> indexOperator;
        private final UnaryOperator<V> valueOperator;

        AbstractFunction(BiFunction<Integer, V, Map.Entry<Integer, V>> entryFactory, UnaryOperator<Integer> indexOperator, UnaryOperator<V> valueOperator) {
            this.entryFactory = entryFactory;
            this.indexOperator = indexOperator;
            this.valueOperator = valueOperator;
        }

        @Override
        public Map.Entry<Integer, V> apply(K key, Map.Entry<Integer, V> entry) {
            Integer index = entry != null ? entry.getKey() : null;
            Object value = entry != null ? entry.getValue() : null;
            Integer newIndex = (Integer)this.indexOperator.apply((Object)index);
            return newIndex != null ? this.entryFactory.apply(newIndex, this.valueOperator.apply(value)) : null;
        }
    }
}

