/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.server.util.Reference;

public interface BlockingReference<T>
extends Reference<T> {
    default public Writer<T> writer(T value) {
        return this.writer((Supplier<T>)org.wildfly.clustering.function.Supplier.of(value));
    }

    default public Writer<T> writer(Supplier<T> supplier) {
        return this.writer((UnaryOperator<T>)org.wildfly.clustering.function.UnaryOperator.of(supplier));
    }

    public Writer<T> writer(UnaryOperator<T> var1);

    public static <T> BlockingReference<T> of(T initialValue) {
        AtomicReference<T> reference = new AtomicReference<T>(initialValue);
        final StampedLock lock = new StampedLock();
        final org.wildfly.clustering.function.Supplier reader = reference::getPlain;
        final Consumer<Object> writer = reference::setPlain;
        return new BlockingReference<T>(){

            @Override
            public Reference.Reader<T> reader() {
                return new Reference.ReferenceReader(lock, reader, Function.identity());
            }

            @Override
            public Writer<T> writer(UnaryOperator<T> updater) {
                return new ReferenceWriter(lock, reader, writer, Function.identity(), updater);
            }
        };
    }

    public static interface Writer<T>
    extends Supplier<T> {
        public <R> Writer<R> map(Function<T, R> var1);

        public Supplier<T> when(Predicate<T> var1);
    }

    public static class ConditionalReferenceWriter<T, V>
    implements Supplier<V> {
        private final StampedLock lock;
        private final Supplier<T> reader;
        private final Consumer<T> writer;
        private final Function<T, V> mapper;
        private final Predicate<V> condition;
        private final UnaryOperator<T> updater;

        ConditionalReferenceWriter(StampedLock lock, Supplier<T> reader, Consumer<T> writer, Function<T, V> mapper, Predicate<V> condition, UnaryOperator<T> updater) {
            this.lock = lock;
            this.reader = reader;
            this.writer = writer;
            this.mapper = mapper;
            this.condition = condition;
            this.updater = updater;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            Object value = null;
            Object result = null;
            boolean update = false;
            long stamp = this.lock.tryOptimisticRead();
            try {
                if (StampedLock.isOptimisticReadStamp(stamp)) {
                    value = this.reader.get();
                    result = this.mapper.apply(value);
                    update = this.condition.test(result);
                }
                if (!this.lock.validate(stamp)) {
                    stamp = this.lock.readLock();
                    value = this.reader.get();
                    result = this.mapper.apply(value);
                    update = this.condition.test(result);
                }
                if (update) {
                    long conversionStamp = this.lock.tryConvertToWriteLock(stamp);
                    if (StampedLock.isWriteLockStamp(conversionStamp)) {
                        stamp = conversionStamp;
                    } else {
                        if (StampedLock.isReadLockStamp(stamp)) {
                            this.lock.unlockRead(stamp);
                        }
                        stamp = this.lock.writeLock();
                    }
                    value = this.reader.get();
                    result = this.mapper.apply(value);
                    if (this.condition.test(result)) {
                        this.writer.accept(this.updater.apply(value));
                    }
                }
                Object t = result;
                return (V)t;
            }
            finally {
                if (StampedLock.isLockStamp(stamp)) {
                    this.lock.unlock(stamp);
                }
            }
        }
    }

    public static class ReferenceWriter<T, V>
    implements Writer<V> {
        private final StampedLock lock;
        private final Supplier<T> reader;
        private final Consumer<T> writer;
        private final Function<T, V> mapper;
        private final UnaryOperator<T> updater;

        ReferenceWriter(StampedLock lock, Supplier<T> reader, Consumer<T> writer, Function<T, V> mapper, UnaryOperator<T> updater) {
            this.lock = lock;
            this.reader = reader;
            this.writer = writer;
            this.mapper = mapper;
            this.updater = updater;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            long stamp = this.lock.writeLock();
            try {
                T value = this.reader.get();
                this.writer.accept(this.updater.apply(value));
                V v = this.mapper.apply(value);
                return v;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        @Override
        public <R> Writer<R> map(Function<V, R> mapper) {
            return new ReferenceWriter<T, R>(this.lock, this.reader, this.writer, this.mapper.andThen(mapper), this.updater);
        }

        @Override
        public Supplier<V> when(Predicate<V> condition) {
            return new ConditionalReferenceWriter<T, V>(this.lock, this.reader, this.writer, this.mapper, condition, this.updater);
        }
    }
}

