/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.expiration;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;

public class ExpirationMetaDataTestCase {
    @Test
    public void immortal() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Optional<Duration> getMaxIdle() {
                return Optional.empty();
            }

            public Optional<Instant> getLastAccessTime() {
                return Optional.of(Instant.now());
            }
        };
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        Assertions.assertThat((Optional)metaData.getExpirationTime()).isEmpty();
    }

    @Test
    public void notYetAccessed() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Optional<Duration> getMaxIdle() {
                return Optional.of(Duration.ofHours(1L));
            }

            public Optional<Instant> getLastAccessTime() {
                return Optional.empty();
            }
        };
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        Assertions.assertThat((Optional)metaData.getExpirationTime()).isEmpty();
    }

    @Test
    public void expired() {
        final Duration maxIdle = Duration.ofHours(1L);
        Instant expiryTime = Instant.now();
        final Instant lastAccessed = expiryTime.minus(maxIdle);
        ExpirationMetaData metaData = new ExpirationMetaData(){
            final /* synthetic */ ExpirationMetaDataTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public Optional<Duration> getMaxIdle() {
                return Optional.of(maxIdle);
            }

            public Optional<Instant> getLastAccessTime() {
                return Optional.of(lastAccessed);
            }
        };
        Assertions.assertThat((boolean)metaData.isExpired()).isTrue();
        Assertions.assertThat((Optional)metaData.getExpirationTime()).hasValue((Object)expiryTime);
    }

    @Test
    public void notYetExpired() {
        final Duration maxIdle = Duration.ofHours(1L);
        final Instant lastAccessed = Instant.now();
        Instant expiryTime = lastAccessed.plus(maxIdle);
        ExpirationMetaData metaData = new ExpirationMetaData(){
            final /* synthetic */ ExpirationMetaDataTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public Optional<Duration> getMaxIdle() {
                return Optional.of(maxIdle);
            }

            public Optional<Instant> getLastAccessTime() {
                return Optional.of(lastAccessed);
            }
        };
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        Assertions.assertThat((Optional)metaData.getExpirationTime()).hasValue((Object)expiryTime);
    }
}

