/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.expiration;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import org.wildfly.clustering.server.expiration.Expiration;

public interface ExpirationMetaData
extends Expiration {
    default public boolean isExpired() {
        Optional<Instant> expirationTime = this.getExpirationTime();
        return expirationTime.isPresent() ? !Instant.now().isBefore(expirationTime.get()) : false;
    }

    default public Optional<Instant> getExpirationTime() {
        Optional<Duration> maxIdle = this.getMaxIdle();
        return maxIdle.isPresent() ? this.getLastAccessTime().map(time -> time.plus((TemporalAmount)maxIdle.get())) : Optional.empty();
    }

    public Optional<Instant> getLastAccessTime();
}

