/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.service.Service;

public class AtomicReferenceService<T extends AutoCloseable>
implements Service {
    private final org.wildfly.clustering.function.UnaryOperator<T> update;
    private final AtomicReference<T> reference;

    public AtomicReferenceService(Supplier<T> factory) {
        this(factory, new AtomicReference());
    }

    public AtomicReferenceService(Supplier<T> factory, AtomicReference<T> reference) {
        this.update = org.wildfly.clustering.function.UnaryOperator.identity().orDefault(Objects::nonNull, factory);
        this.reference = reference;
    }

    @Override
    public boolean isStarted() {
        return this.reference.get() != null;
    }

    @Override
    public void start() {
        Consumer.close().accept((Object)((AutoCloseable)this.reference.getAndUpdate((UnaryOperator<T>)this.update)));
    }

    @Override
    public void stop() {
        Consumer.close().accept((Object)this.reference.getAndSet(null));
    }
}

