/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.function.UnaryOperator;
import org.wildfly.clustering.server.util.BlockingReference;
import org.wildfly.clustering.server.util.Reference;

public interface BlockingReferenceMap<K, V>
extends Reference<Map<K, V>> {
    public BlockingReference<V> reference(K var1);

    public static <K, V> BlockingReferenceMap<K, V> of(final Map<K, V> map) {
        final StampedLock lock = new StampedLock();
        final Supplier reader = Supplier.of(map).thenApply(Collections::unmodifiableMap);
        final UnaryOperator mapper = UnaryOperator.identity();
        return new BlockingReferenceMap<K, V>(){

            @Override
            public BlockingReference<V> reference(K key) {
                final Supplier reader2 = Supplier.of(key).thenApply(map::get);
                final Consumer writer = value -> map.put(key, value);
                final UnaryOperator mapper2 = UnaryOperator.identity();
                return new BlockingReference<V>(this){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Reference.Reader<V> reader() {
                        return new Reference.ReferenceReader(lock, reader2, mapper2);
                    }

                    @Override
                    public BlockingReference.Writer<V> writer(UnaryOperator<V> updater) {
                        return new BlockingReference.ReferenceWriter(lock, reader2, writer, mapper2, updater);
                    }
                };
            }

            @Override
            public Reference.Reader<Map<K, V>> reader() {
                return new Reference.ReferenceReader(lock, reader, mapper);
            }
        };
    }
}

