/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.offset;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.OffsetValue;

public class OffsetValueTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        OffsetValue value = OffsetValue.from((Duration)Duration.ZERO);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isTrue();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.get())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)backward))).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)forward))).isSameAs((Object)forward);
        value.set((Object)forward);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.get())).isEqualTo((Object)forward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)backward))).isZero();
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isEqualTo((Object)forward);
        OffsetValue rebaseValue = value.rebase();
        Assertions.assertThat((boolean)rebaseValue.getOffset().isZero()).isTrue();
        Assertions.assertThat((Duration)((Duration)rebaseValue.getBasis())).isEqualTo((Object)forward);
        Assertions.assertThat((Duration)((Duration)rebaseValue.get())).isEqualTo((Object)forward);
        Assertions.assertThat((Duration)((Duration)rebaseValue.getOffset().apply((Object)Duration.ZERO))).isZero();
        Assertions.assertThat((Duration)((Duration)rebaseValue.getOffset().apply((Object)forward))).isEqualTo((Object)forward);
        value.set((Object)backward);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.get())).isEqualTo((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isEqualTo((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)forward))).isZero();
        Assertions.assertThat((boolean)rebaseValue.getOffset().isZero()).isTrue();
        Assertions.assertThat((Duration)((Duration)rebaseValue.getBasis())).isEqualTo(value.get());
        Assertions.assertThat((Duration)((Duration)rebaseValue.get())).isEqualTo(value.get());
        Assertions.assertThat((Duration)((Duration)rebaseValue.getOffset().apply((Object)Duration.ZERO))).isZero();
        Assertions.assertThat((Duration)((Duration)rebaseValue.getOffset().apply((Object)forward))).isEqualTo((Object)forward);
        value = OffsetValue.from((Duration)forward);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isTrue();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)forward);
        Assertions.assertThat((Duration)((Duration)value.get())).isSameAs((Object)forward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)backward))).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)forward))).isEqualTo((Object)forward);
        value.set((Object)Duration.ZERO);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)forward);
        Assertions.assertThat((Duration)((Duration)value.get())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isEqualTo((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)forward))).isZero();
        value = OffsetValue.from((Duration)backward);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isTrue();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.get())).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)backward))).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)forward))).isEqualTo((Object)forward);
        value.set((Object)Duration.ZERO);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Duration)((Duration)value.getBasis())).isSameAs((Object)backward);
        Assertions.assertThat((Duration)((Duration)value.get())).isSameAs((Object)Duration.ZERO);
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)backward))).isZero();
        Assertions.assertThat((Duration)((Duration)value.getOffset().apply((Object)Duration.ZERO))).isEqualTo((Object)forward);
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        OffsetValue value = OffsetValue.from((Instant)present);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isTrue();
        Assertions.assertThat((Instant)((Instant)value.getBasis())).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)value.get())).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)past))).isSameAs((Object)past);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)present))).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)future))).isSameAs((Object)future);
        value.set((Object)future);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Instant)((Instant)value.getBasis())).isEqualTo((Object)present);
        Assertions.assertThat((Instant)((Instant)value.get())).isEqualTo((Object)future);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)past))).isEqualTo((Object)present);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)present))).isEqualTo((Object)future);
        OffsetValue rebaseValue = value.rebase();
        Assertions.assertThat((boolean)rebaseValue.getOffset().isZero()).isTrue();
        Assertions.assertThat((Instant)((Instant)rebaseValue.getBasis())).isEqualTo((Object)future);
        Assertions.assertThat((Instant)((Instant)rebaseValue.get())).isEqualTo((Object)future);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)past))).isSameAs((Object)past);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)present))).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)future))).isSameAs((Object)future);
        value.set((Object)past);
        Assertions.assertThat((boolean)value.getOffset().isZero()).isFalse();
        Assertions.assertThat((Instant)((Instant)value.getBasis())).isEqualTo((Object)present);
        Assertions.assertThat((Instant)((Instant)value.get())).isEqualTo((Object)past);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)present))).isEqualTo((Object)past);
        Assertions.assertThat((Instant)((Instant)value.getOffset().apply((Object)future))).isEqualTo((Object)present);
        Assertions.assertThat((boolean)rebaseValue.getOffset().isZero()).isTrue();
        Assertions.assertThat((Instant)((Instant)rebaseValue.getBasis())).isEqualTo((Object)past);
        Assertions.assertThat((Instant)((Instant)rebaseValue.get())).isEqualTo((Object)past);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)past))).isSameAs((Object)past);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)present))).isSameAs((Object)present);
        Assertions.assertThat((Instant)((Instant)rebaseValue.getOffset().apply((Object)future))).isSameAs((Object)future);
    }
}

