/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.server.context.Context;
import org.wildfly.clustering.server.context.ContextFactory;
import org.wildfly.clustering.server.context.Contextual;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.ContextualSession;
import org.wildfly.clustering.session.cache.ContextualSessionRegistration;
import org.wildfly.common.function.Functions;

public class ContextualSessionManager<C, B extends Batch>
implements SessionManager<C, B> {
    private final SessionManager<C, B> manager;
    private final Context<String, CompletionStage<ContextualSession<C>>> sessionContext;
    private final BiFunction<String, Runnable, CompletionStage<ContextualSession<C>>> sessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<ContextualSession<C>>> sessionFinder;
    private final UnaryOperator<Session<C>> validator = new UnaryOperator<Session<C>>(){

        @Override
        public Session<C> apply(Session<C> session) {
            if (session != null && !session.isValid()) {
                session.close();
                return null;
            }
            return session;
        }
    };

    public ContextualSessionManager(final SessionManager<C, B> manager, ContextFactory contextFactory) {
        this.manager = manager;
        this.sessionCreator = new BiFunction<String, Runnable, CompletionStage<ContextualSession<C>>>(){

            @Override
            public CompletionStage<ContextualSession<C>> apply(String id, Runnable closeTask) {
                return manager.createSessionAsync(id).thenApply(session -> new ContextualSessionRegistration(session, closeTask));
            }
        };
        final Function<Runnable, ContextualSession> empty = closeTask -> {
            closeTask.run();
            return null;
        };
        this.sessionFinder = new BiFunction<String, Runnable, CompletionStage<ContextualSession<C>>>(){

            @Override
            public CompletionStage<ContextualSession<C>> apply(String id, Runnable closeTask) {
                return manager.findSessionAsync(id).thenApply(session -> session != null ? new ContextualSessionRegistration(session, closeTask) : (ContextualSession)empty.apply(closeTask));
            }
        };
        this.sessionContext = contextFactory.createContext(Functions.discardingConsumer(), new Consumer<CompletionStage<ContextualSession<C>>>(){

            @Override
            public void accept(CompletionStage<ContextualSession<C>> future) {
                future.thenAccept(session -> Optional.ofNullable(session).ifPresent(Contextual::end));
            }
        });
    }

    public CompletionStage<Session<C>> createSessionAsync(String id) {
        return ((CompletionStage)this.sessionContext.computeIfAbsent((Object)id, this.sessionCreator)).thenApply(Function.identity());
    }

    public CompletionStage<Session<C>> findSessionAsync(String id) {
        return ((CompletionStage)this.sessionContext.computeIfAbsent((Object)id, this.sessionFinder)).thenApply(this.validator);
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String id) {
        return this.manager.findImmutableSessionAsync(id);
    }

    public Supplier<String> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public Batcher<B> getBatcher() {
        return this.manager.getBatcher();
    }

    public SessionStatistics getStatistics() {
        return this.manager.getStatistics();
    }
}

