/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.server.context.ContextFactory;
import org.wildfly.clustering.server.context.ContextStrategy;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.ContextualSessionManager;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;

public class ContextualSessionManagerTestCase {
    @Test
    public void findSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.SHARED);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(expected2)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.findSession(id);){
            Assertions.assertNotNull((Object)session1);
            Assertions.assertSame((Object)id, (Object)session1.getId());
            Assertions.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assertions.assertSame((Object)attributes1, (Object)session1.getAttributes());
            try (Session session2 = subject.findSession(id);){
                Assertions.assertNotNull((Object)session2);
                Assertions.assertSame((Object)session1, (Object)session2);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.findSession(id);){
            Assertions.assertNotNull((Object)session);
            Assertions.assertSame((Object)id, (Object)session.getId());
            Assertions.assertSame((Object)metaData2, (Object)session.getMetaData());
            Assertions.assertSame((Object)attributes2, (Object)session.getAttributes());
        }
    }

    @Test
    public void findInvalidSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.SHARED);
        Session expected1 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(null)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        try (Session session1 = subject.findSession(id);){
            Assertions.assertNotNull((Object)session1);
            Assertions.assertSame((Object)id, (Object)session1.getId());
            Assertions.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assertions.assertSame((Object)attributes1, (Object)session1.getAttributes());
            session1.invalidate();
            ((Session)Mockito.verify((Object)expected1)).invalidate();
            ((Session)Mockito.verify((Object)expected1)).close();
            Session session2 = subject.findSession(id);
            Assertions.assertNull((Object)session2);
        }
    }

    @Test
    public void createSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.SHARED);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.createSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(expected2)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.createSession(id);){
            Assertions.assertNotNull((Object)session1);
            Assertions.assertSame((Object)id, (Object)session1.getId());
            Assertions.assertSame((Object)metaData1, (Object)session1.getMetaData());
            Assertions.assertSame((Object)attributes1, (Object)session1.getAttributes());
            try (Session session2 = subject.findSession(id);){
                Assertions.assertNotNull((Object)session2);
                Assertions.assertSame((Object)session1, (Object)session2);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.createSession(id);){
            Assertions.assertNotNull((Object)session);
            Assertions.assertSame((Object)id, (Object)session.getId());
            Assertions.assertSame((Object)metaData2, (Object)session.getMetaData());
            Assertions.assertSame((Object)attributes2, (Object)session.getAttributes());
        }
    }

    @Test
    public void getIdentifierFactory() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)manager.getIdentifierFactory()).thenReturn((Object)expected);
        Supplier result = subject.getIdentifierFactory();
        Assertions.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void start() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        subject.start();
        ((SessionManager)Mockito.verify((Object)manager)).start();
    }

    @Test
    public void stop() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        subject.stop();
        ((SessionManager)Mockito.verify((Object)manager)).stop();
    }

    @Test
    public void getStatistics() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionStatistics statistics = (SessionStatistics)Mockito.mock(SessionStatistics.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        Mockito.when((Object)manager.getStatistics()).thenReturn((Object)statistics);
        Assertions.assertSame((Object)statistics, (Object)subject.getStatistics());
    }

    @Test
    public void getBatcher() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        Batcher expected = (Batcher)Mockito.mock(Batcher.class);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)expected);
        Batcher result = subject.getBatcher();
        Assertions.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void findImmutableSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        ContextualSessionManager subject = new ContextualSessionManager(manager, (ContextFactory)ContextStrategy.UNSHARED);
        ImmutableSession expected = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        String id = "foo";
        Mockito.when((Object)manager.findImmutableSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected));
        ImmutableSession result = subject.findImmutableSession(id);
        Assertions.assertSame((Object)expected, (Object)result);
    }
}

