/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.AbstractImmutableSessionMetaDataTestCase;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;

public class DefaultSessionMetaDataTestCase
extends AbstractImmutableSessionMetaDataTestCase {
    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void testCreationTime(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.testCreationTime((ImmutableSessionMetaDataEntry)entry, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void testLastAccessStartTime(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.testLastAccessStartTime((ImmutableSessionMetaDataEntry)entry, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void testLastAccessEndTime(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.testLastAccessEndTime((ImmutableSessionMetaDataEntry)entry, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void testTimeout(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.testTimeout((ImmutableSessionMetaDataEntry)entry, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void setLastAccess(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        Instant endTime = Instant.now();
        Instant startTime = endTime.minus(Duration.ofMillis(500L));
        OffsetValue lastAccessStartTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        OffsetValue lastAccessEndTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ArgumentCaptor lastAccessStartTimeCaptor = ArgumentCaptor.forClass(Instant.class);
        ArgumentCaptor lastAccessEndTimeCaptor = ArgumentCaptor.forClass(Instant.class);
        ((MutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessStartTime).when((Object)entry)).getLastAccessStartTime();
        ((MutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessEndTime).when((Object)entry)).getLastAccessEndTime();
        ((OffsetValue)Mockito.doNothing().when((Object)lastAccessStartTime)).set((Object)((Instant)lastAccessStartTimeCaptor.capture()));
        ((OffsetValue)Mockito.doNothing().when((Object)lastAccessEndTime)).set((Object)((Instant)lastAccessEndTimeCaptor.capture()));
        metaData.setLastAccess(startTime, endTime);
        Instant normalizedStartTime = (Instant)lastAccessStartTimeCaptor.getValue();
        Instant normalizedEndTime = (Instant)lastAccessEndTimeCaptor.getValue();
        Assertions.assertEquals((int)0, (int)(normalizedStartTime.getNano() % Duration.ofMillis(1L).getNano()));
        Assertions.assertEquals((long)startTime.toEpochMilli(), (long)normalizedStartTime.toEpochMilli());
        Duration lastAccessDuration = Duration.between(normalizedStartTime, normalizedEndTime);
        Assertions.assertEquals((long)1L, (long)lastAccessDuration.getSeconds());
        Assertions.assertEquals((int)0, (int)lastAccessDuration.getNano());
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void setTimeout(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        Duration timeout = Duration.ofHours(1L);
        metaData.setTimeout(timeout);
        ((MutableSessionMetaDataEntry)Mockito.verify((Object)entry)).setTimeout(timeout);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void invalidate(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        Assertions.assertTrue((boolean)metaData.isValid());
        metaData.invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{entry});
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Assertions.assertFalse((boolean)metaData.isValid());
    }

    @ParameterizedTest(name="{index}")
    @ArgumentsSource(value=Parameters.class)
    public void close(MutableSessionMetaDataEntry entry, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        metaData.close();
        Mockito.verifyNoInteractions((Object[])new Object[]{entry});
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).mutate();
    }

    static class Parameters
    implements ArgumentsProvider {
        Parameters() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            MutableSessionMetaDataEntry entry = (MutableSessionMetaDataEntry)Mockito.mock(MutableSessionMetaDataEntry.class);
            CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
            DefaultSessionMetaData metaData = new DefaultSessionMetaData((SessionMetaDataEntry)entry, mutator);
            return Stream.of(Arguments.of((Object[])new Object[]{entry, mutator, metaData}));
        }
    }
}

