/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.Remover;
import org.wildfly.clustering.session.cache.user.CompositeUser;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;

public class CompositeUserTestCase {
    private final String id = "id";
    private final UserSessions<String, String> sessions = (UserSessions)Mockito.mock(UserSessions.class);
    private final String context = "context";
    private final String localContext = "local-context";
    private final Remover<String> remover = (Remover)Mockito.mock(Remover.class);
    private final User<String, Object, String, String> user = new CompositeUser(this.id, Map.entry(this.context, this.localContext), this.sessions, this.remover);

    @Test
    public void getId() {
        Assertions.assertSame((Object)this.id, (Object)this.user.getId());
    }

    @Test
    public void getContext() {
        Assertions.assertSame((Object)this.context, (Object)this.user.getPersistentContext());
    }

    @Test
    public void getSessions() {
        Assertions.assertSame(this.sessions, (Object)this.user.getSessions());
    }

    @Test
    public void invalidate() {
        this.user.invalidate();
        ((Remover)Mockito.verify(this.remover)).remove((Object)this.id);
    }

    @Test
    public void getLocalContext() {
        Assertions.assertSame((Object)this.localContext, (Object)this.user.getTransientContext());
    }
}

