/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiCreator;
import org.wildfly.clustering.cache.BiLocator;
import org.wildfly.clustering.cache.Remover;
import org.wildfly.clustering.session.cache.user.UserContextFactory;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.user.User;

public interface UserFactory<CV, C, T, SV, D, S>
extends BiCreator<String, CV, SV, C>,
BiLocator<String, CV, SV>,
Remover<String> {
    public UserContextFactory<CV, C, T> getUserContextFactory();

    public UserSessionsFactory<SV, D, S> getUserSessionsFactory();

    public User<C, T, D, S> createUser(String var1, Map.Entry<CV, SV> var2);

    default public CompletionStage<User<C, T, D, S>> createUserAsync(String id, Map.Entry<CompletionStage<CV>, CompletionStage<SV>> entry) {
        return entry.getKey().thenCombine(entry.getValue(), AbstractMap.SimpleImmutableEntry::new).thenApply(value -> this.createUser(id, (Map.Entry<CV, SV>)value));
    }

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> createEntry(String id, C context) {
        return Map.entry(this.getUserContextFactory().createValueAsync(id, context), this.getUserSessionsFactory().createValueAsync(id, null));
    }

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> findEntry(String id) {
        return Map.entry(this.getUserContextFactory().findValueAsync(id), this.getUserSessionsFactory().findValueAsync(id));
    }

    default public Map.Entry<CompletionStage<CV>, CompletionStage<SV>> tryEntry(String id) {
        return Map.entry(this.getUserContextFactory().tryValueAsync(id), this.getUserSessionsFactory().tryValueAsync(id));
    }

    default public CompletionStage<Void> removeAsync(String id) {
        return CompletableFuture.allOf(this.getUserContextFactory().removeAsync(id).toCompletableFuture(), this.getUserSessionsFactory().removeAsync(id).toCompletableFuture());
    }

    default public CompletionStage<Void> purgeAsync(String id) {
        return CompletableFuture.allOf(this.getUserContextFactory().purgeAsync(id).toCompletableFuture(), this.getUserSessionsFactory().purgeAsync(id).toCompletableFuture());
    }
}

