/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;

public class DetachedSessionAttributes<C, B extends Batch>
implements SessionAttributes {
    private final Supplier<B> batchFactory;
    private final Supplier<Session<C>> sessionFactory;

    public DetachedSessionAttributes(Supplier<B> batchFactory, Supplier<Session<C>> sessionFactory) {
        this.batchFactory = batchFactory;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Set<String> keySet() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Set<String> set;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    set = session.getAttributes().keySet();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return set;
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Set<Map.Entry<String, Object>> set;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    set = session.getAttributes().entrySet();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return set;
        }
    }

    @Override
    public Collection<Object> values() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Collection<Object> collection;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    collection = session.getAttributes().values();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return collection;
        }
    }

    @Override
    public Object get(Object name) {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Object v;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    v = session.getAttributes().get(name);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return v;
        }
    }

    @Override
    public Object put(String name, Object value) {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Object object;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    object = session.getAttributes().put(name, value);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return object;
        }
    }

    @Override
    public Object remove(Object key) {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Object v;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    v = session.getAttributes().remove(key);
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return v;
        }
    }

    public void close() {
    }
}

