/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.fine;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import java.util.TreeMap;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.cache.attributes.AbstractSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;

public class FineSessionAttributes<K, V>
extends AbstractSessionAttributes {
    private final K key;
    private final Map<String, Object> attributes;
    private final Marshaller<Object, V> marshaller;
    private final CacheEntryMutatorFactory<K, Map<String, V>> mutatorFactory;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final SessionAttributeActivationNotifier notifier;
    private final Map<String, Object> updates = new TreeMap<String, Object>();

    public FineSessionAttributes(K key, Map<String, Object> attributes, CacheEntryMutatorFactory<K, Map<String, V>> mutatorFactory, Marshaller<Object, V> marshaller, Immutability immutability, CacheProperties properties, SessionAttributeActivationNotifier notifier) {
        super(attributes);
        this.key = key;
        this.attributes = attributes;
        this.mutatorFactory = mutatorFactory;
        this.marshaller = marshaller;
        this.immutability = immutability;
        this.properties = properties;
        this.notifier = notifier;
        if (this.notifier != null) {
            for (Object value : this.attributes.values()) {
                this.notifier.postActivate(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String name = (String)key;
        Object value = this.attributes.get(name);
        if (value != null && !this.immutability.test(value)) {
            Map<String, Object> map = this.updates;
            synchronized (map) {
                this.updates.put(name, value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String name = (String)key;
        Object result = this.attributes.remove(name);
        if (result != null) {
            Map<String, Object> map = this.updates;
            synchronized (map) {
                this.updates.put(name, null);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String name, Object value) {
        if (value == null) {
            return this.remove(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(value)) {
            throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
        }
        Object result = this.attributes.put(name, value);
        Map<String, Object> map = this.updates;
        synchronized (map) {
            this.updates.put(name, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.notifier != null) {
            for (Object e : this.attributes.values()) {
                this.notifier.prePassivate(e);
            }
        }
        Map<String, Object> map = this.updates;
        synchronized (map) {
            if (!this.updates.isEmpty()) {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                for (Map.Entry<String, Object> entry : this.updates.entrySet()) {
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    treeMap.put(name, value != null ? (Object)this.write(value) : null);
                }
                this.mutatorFactory.createMutator(this.key, treeMap).mutate();
            }
        }
    }

    private V write(Object value) {
        try {
            return (V)this.marshaller.write(value);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

