/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiLocator;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.attributes.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;

public interface ImmutableSessionFactory<MV, AV>
extends BiLocator<String, MV, AV> {
    public ImmutableSessionMetaDataFactory<MV> getMetaDataFactory();

    public ImmutableSessionAttributesFactory<AV> getAttributesFactory();

    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> findEntry(String id) {
        return Map.entry(this.getMetaDataFactory().findValueAsync(id), this.getAttributesFactory().findValueAsync(id));
    }

    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> tryEntry(String id) {
        return Map.entry(this.getMetaDataFactory().tryValueAsync(id), this.getAttributesFactory().tryValueAsync(id));
    }

    default public ImmutableSession createImmutableSession(String id, Map.Entry<MV, AV> entry) {
        MV metaDataValue = entry.getKey();
        AV attributesValue = entry.getValue();
        if (metaDataValue == null || attributesValue == null) {
            return null;
        }
        ImmutableSessionMetaData metaData = this.getMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue);
        ImmutableSessionAttributes attributes = this.getAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
        return this.createImmutableSession(id, metaData, attributes);
    }

    public ImmutableSession createImmutableSession(String var1, ImmutableSessionMetaData var2, ImmutableSessionAttributes var3);
}

