/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.container.SessionActivationListenerFacadeProvider;

public class ImmutableSessionActivationNotifier<S, C, L>
implements SessionActivationNotifier {
    private final SessionActivationListenerFacadeProvider<S, C, L> provider;
    private final ImmutableSession session;
    private final C context;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final Function<L, Consumer<S>> prePassivateNotifier;
    private final Function<L, Consumer<S>> postActivateNotifier;

    public ImmutableSessionActivationNotifier(SessionActivationListenerFacadeProvider<S, C, L> provider, ImmutableSession session, C context) {
        this.provider = provider;
        this.session = session;
        this.context = context;
        this.prePassivateNotifier = arg_0 -> this.provider.prePassivateNotifier(arg_0);
        this.postActivateNotifier = arg_0 -> this.provider.postActivateNotifier(arg_0);
    }

    @Override
    public void prePassivate() {
        if (this.active.compareAndSet(true, false)) {
            this.notify(this.prePassivateNotifier);
        }
    }

    @Override
    public void postActivate() {
        if (this.active.compareAndSet(false, true)) {
            this.notify(this.postActivateNotifier);
        }
    }

    private void notify(Function<L, Consumer<S>> notifierFactory) {
        ImmutableSessionAttributes attributes = this.session.getAttributes();
        Set attributeNames = attributes.getAttributeNames();
        if (!attributeNames.isEmpty()) {
            ArrayList listeners = new ArrayList(attributeNames.size());
            for (String attributeName : attributeNames) {
                Object attributeValue = attributes.getAttribute(attributeName);
                if (attributeValue == null) continue;
                this.provider.asSessionActivationListener(attributeValue).ifPresent(listeners::add);
            }
            if (!listeners.isEmpty()) {
                Object session = this.provider.asSession(this.session, this.context);
                for (Object listener : listeners) {
                    notifierFactory.apply(listener).accept(session);
                }
            }
        }
    }
}

