/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.affinity;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.session.cache.affinity.NarySessionAffinity;
import org.wildfly.clustering.session.cache.affinity.NarySessionAffinityConfiguration;

public class NarySessionAffinityTestCase {
    @Test
    public void test() {
        GroupMember primary = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember backup = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember local = (GroupMember)Mockito.mock(GroupMember.class);
        Map<String, List<GroupMember>> affinity = Map.of("session", List.of(primary, backup, local));
        Map<GroupMember, String> mapping = Map.of(primary, "foo", backup, "bar", local, "qux");
        NarySessionAffinity sessionAffinity = new NarySessionAffinity(affinity::get, mapping::get, () -> "#");
        Assertions.assertEquals((Object)"foo#bar#qux", sessionAffinity.apply("session"));
    }

    @Test
    public void testDupes() {
        GroupMember primary = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember backup = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember local = (GroupMember)Mockito.mock(GroupMember.class);
        Map<String, List<GroupMember>> affinity = Map.of("session", List.of(primary, backup, local));
        Map<GroupMember, String> mapping = Map.of(primary, "foo", backup, "bar", local, "bar");
        NarySessionAffinity sessionAffinity = new NarySessionAffinity(affinity::get, mapping::get, () -> "-");
        Assertions.assertEquals((Object)"foo-bar", sessionAffinity.apply("session"));
    }

    @Test
    public void testLimit() {
        GroupMember primary = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember backup = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember local = (GroupMember)Mockito.mock(GroupMember.class);
        Map<String, List<GroupMember>> affinity = Map.of("session", List.of(primary, backup, local));
        Map<GroupMember, String> mapping = Map.of(primary, "foo", backup, "bar", local, "qux");
        NarySessionAffinity sessionAffinity = new NarySessionAffinity(affinity::get, mapping::get, new NarySessionAffinityConfiguration(){

            public String getDelimiter() {
                return ",";
            }

            public int getMaxMembers() {
                return 2;
            }
        });
        Assertions.assertEquals((Object)"foo,bar", sessionAffinity.apply("session"));
    }
}

