/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.DetachedSession;

public class DetachedSessionTestCase {
    private final SessionManager<Object, Batch> manager = (SessionManager)Mockito.mock(SessionManager.class);
    private final String id = UUID.randomUUID().toString();
    private final Object localContext = new Object();
    private final Session<Object> session = new DetachedSession(this.manager, this.id, this.localContext);

    @Test
    public void getId() {
        Assertions.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void isNew() {
        Assertions.assertFalse((boolean)this.session.getMetaData().isNew());
    }

    @Test
    public void isValid() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findImmutableSession(this.id)).thenReturn(null);
        Assertions.assertFalse((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        Mockito.when((Object)this.manager.findImmutableSession(this.id)).thenReturn((Object)session);
        Assertions.assertTrue((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void invalidate() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.invalidate());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        this.session.invalidate();
        ((Session)Mockito.verify((Object)session)).invalidate();
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void isExpired() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).isExpired());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        boolean expected = true;
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)expected);
        boolean result = this.session.getMetaData().isExpired();
        Assertions.assertEquals((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getCreationTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getCreationTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getCreationTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessStartTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessStartTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessStartTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getLastAccessStartTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessEndTime() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessEndTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessEndTime()).thenReturn((Object)expected);
        Instant result = this.session.getMetaData().getLastAccessEndTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getMaxInactiveInterval() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getTimeout());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Duration expected = Duration.ZERO;
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getTimeout()).thenReturn((Object)expected);
        Duration result = this.session.getMetaData().getTimeout();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setLastAccess() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setLastAccess(Instant.now(), Instant.now()));
    }

    @Test
    public void setTimeout() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Duration duration = Duration.ZERO;
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setTimeout(duration));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        this.session.getMetaData().setTimeout(duration);
        ((SessionMetaData)Mockito.verify((Object)metaData)).setTimeout(duration);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttributeNames() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, this.session.getAttributes()::keySet);
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Set<String> expected = Collections.singleton("foo");
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when(attributes.keySet()).thenReturn(expected);
        Set result = this.session.getAttributes().keySet();
        Assertions.assertSame(expected, result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().get(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when(attributes.get(attributeName)).thenReturn(expected);
        Object result = this.session.getAttributes().get(attributeName);
        Assertions.assertSame((Object)expected, result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        String attributeValue = "bar";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().put(attributeName, attributeValue));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.put(attributeName, attributeValue)).thenReturn(expected);
        String result = this.session.getAttributes().put(attributeName, attributeValue);
        Assertions.assertSame((Object)expected, (Object)result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void removeAttribute() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn(null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().remove(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        Mockito.when((Object)this.manager.findSession(this.id)).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when(attributes.remove(attributeName)).thenReturn(expected);
        Object result = this.session.getAttributes().remove(attributeName);
        Assertions.assertSame((Object)expected, result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }
}

