/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.affinity;

import java.util.AbstractMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.session.cache.affinity.SessionAffinityRegistryGroupMemberMapper;

public class SessionAffinityRegistryGroupMemberMapperTestCase {
    @Test
    public void test() {
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Group group = (Group)Mockito.mock(Group.class);
        GroupMember localMember = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember remoteMember = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember leftMember = (GroupMember)Mockito.mock(GroupMember.class);
        String localAffinity = "foo";
        String remoteAffinity = "bar";
        ((Registry)Mockito.doReturn((Object)group).when((Object)registry)).getGroup();
        ((Group)Mockito.doReturn((Object)localMember).when((Object)group)).getLocalMember();
        ((Registry)Mockito.doReturn(new AbstractMap.SimpleImmutableEntry<String, Object>(localAffinity, null)).when((Object)registry)).getEntry(localMember);
        ((Registry)Mockito.doReturn(new AbstractMap.SimpleImmutableEntry<String, Object>(remoteAffinity, null)).when((Object)registry)).getEntry(remoteMember);
        SessionAffinityRegistryGroupMemberMapper mapper = new SessionAffinityRegistryGroupMemberMapper(registry);
        Assertions.assertSame((Object)localAffinity, mapper.apply(null));
        Assertions.assertSame((Object)localAffinity, mapper.apply(localMember));
        Assertions.assertSame((Object)localAffinity, mapper.apply(leftMember));
        Assertions.assertSame((Object)remoteAffinity, mapper.apply(remoteMember));
    }
}

