/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.AbstractImmutableSessionMetaDataTestCase;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;

public class CompositeSessionMetaDataTestCase
extends AbstractImmutableSessionMetaDataTestCase {
    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void isNew(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.isNew((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void isExpired(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.isExpired((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getCreationTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.getCreationTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getLastAccessStartTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.getLastAccessStartTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getLastAccessEndTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.getLastAccessEndTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getMaxInactiveInterval(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        super.getMaxInactiveInterval((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void setLastAccessedTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        Instant endTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        Duration lastAccess = Duration.ofSeconds(1L);
        Instant startTime = endTime.minus(lastAccess);
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)startTime);
        metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)accessMetaData)).setLastAccessDuration(Duration.ZERO, lastAccess);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.reset((Object[])new Object[]{creationMetaData, accessMetaData});
        Duration sinceCreated = Duration.ofSeconds(10L);
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)startTime.minus(sinceCreated));
        metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)accessMetaData)).setLastAccessDuration(sinceCreated, lastAccess);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void setMaxInactiveInterval(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        Duration duration = Duration.ZERO;
        metaData.setTimeout(duration);
        ((SessionCreationMetaData)Mockito.verify((Object)creationMetaData)).setTimeout(duration);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void close(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, CacheEntryMutator mutator, InvalidatableSessionMetaData metaData) {
        metaData.close();
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).mutate();
    }

    static class Parameters
    implements ArgumentsProvider {
        Parameters() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
            CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
            CompositeSessionMetaData metaData = new CompositeSessionMetaData(creationMetaData, accessMetaData, mutator);
            return Stream.of(Arguments.of((Object[])new Object[]{creationMetaData, accessMetaData, mutator, metaData}));
        }
    }
}

