/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.CompositeSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.common.function.Functions;

public class CompositeSessionTestCase {
    private final String id = "session";
    private final InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
    private final SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
    private final CacheEntryRemover<String> remover = (CacheEntryRemover)Mockito.mock(CacheEntryRemover.class);
    private final Object context = new Object();
    private final Session<Object> session = new CompositeSession(this.id, this.metaData, this.attributes, Supplied.simple(), Functions.constantSupplier((Object)this.context), this.remover);

    @Test
    public void getId() {
        Assertions.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void getAttributes() {
        Assertions.assertSame((Object)this.attributes, (Object)this.session.getAttributes());
    }

    @Test
    public void getMetaData() {
        Assertions.assertSame((Object)this.metaData, (Object)this.session.getMetaData());
    }

    @Test
    public void invalidate() {
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)true);
        this.session.invalidate();
        ((CacheEntryRemover)Mockito.verify(this.remover)).remove((Object)this.id);
        Mockito.reset((Object[])new CacheEntryRemover[]{this.remover});
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)false);
        this.session.invalidate();
        ((CacheEntryRemover)Mockito.verify(this.remover, (VerificationMode)Mockito.never())).remove((Object)this.id);
    }

    @Test
    public void isValid() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.session.isValid());
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.session.isValid());
    }

    @Test
    public void close() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes)).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData)).close();
        Mockito.reset((Object[])new AutoCloseable[]{this.metaData, this.attributes});
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes, (VerificationMode)Mockito.never())).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void getLocalContext() {
        Object result = this.session.getContext();
        Assertions.assertSame((Object)this.context, (Object)result);
    }
}

