/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.DetachedSession;

public class DetachedSessionTestCase {
    private final SessionManager<Object> manager = (SessionManager)Mockito.mock(SessionManager.class);
    private final String id = UUID.randomUUID().toString();
    private final Object localContext = new Object();
    private final Session<Object> session = new DetachedSession(this.manager, this.id, this.localContext);

    @Test
    public void getId() {
        Assertions.assertSame((Object)this.id, (Object)this.session.getId());
    }

    @Test
    public void isNew() {
        Assertions.assertFalse((boolean)this.session.getMetaData().isNew());
    }

    @Test
    public void isValid() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findImmutableSession(this.id);
        Assertions.assertFalse((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findImmutableSession(this.id);
        Assertions.assertTrue((boolean)this.session.isValid());
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void invalidate() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.invalidate());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        this.session.invalidate();
        ((Session)Mockito.verify((Object)session)).invalidate();
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void isExpired() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).isExpired());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        boolean expected = true;
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).isExpired();
        boolean result = this.session.getMetaData().isExpired();
        Assertions.assertEquals((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getCreationTime() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getCreationTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).getCreationTime();
        Instant result = this.session.getMetaData().getCreationTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessStartTime() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessStartTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).getLastAccessStartTime();
        Instant result = this.session.getMetaData().getLastAccessStartTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getLastAccessEndTime() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getLastAccessEndTime());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant expected = Instant.now();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).getLastAccessEndTime();
        Instant result = this.session.getMetaData().getLastAccessEndTime();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getMaxInactiveInterval() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> ((SessionMetaData)this.session.getMetaData()).getTimeout());
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Duration expected = Duration.ZERO;
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).getTimeout();
        Duration result = this.session.getMetaData().getTimeout();
        Assertions.assertSame((Object)expected, (Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setLastAccess() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setLastAccess(Instant.now(), Instant.now()));
    }

    @Test
    public void setTimeout() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Duration duration = Duration.ZERO;
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getMetaData().setTimeout(duration));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        this.session.getMetaData().setTimeout(duration);
        ((SessionMetaData)Mockito.verify((Object)metaData)).setTimeout(duration);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttributeNames() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, this.session.getAttributes()::keySet);
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Set<String> expected = Collections.singleton("foo");
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
        ((Map)Mockito.doReturn(expected).when((Object)attributes)).keySet();
        Set result = this.session.getAttributes().keySet();
        Assertions.assertSame(expected, result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getAttribute() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().get(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).get(attributeName);
        Object result = this.session.getAttributes().get(attributeName);
        Assertions.assertSame((Object)expected, result);
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void setAttribute() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        String attributeValue = "bar";
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().put(attributeName, attributeValue));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).put(attributeName, attributeValue);
        String result = this.session.getAttributes().put(attributeName, attributeValue);
        Assertions.assertSame((Object)expected, (Object)result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void removeAttribute() {
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String attributeName = "foo";
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when(this.manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch).when((Object)batchFactory)).get();
        ((SessionManager)Mockito.doReturn(null).when(this.manager)).findSession(this.id);
        Assertions.assertThrows(IllegalStateException.class, () -> this.session.getAttributes().remove(attributeName));
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
        Session session = (Session)Mockito.mock(Session.class);
        Map attributes = (Map)Mockito.mock(Map.class);
        Object expected = new Object();
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).findSession(this.id);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
        ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).remove(attributeName);
        Object result = this.session.getAttributes().remove(attributeName);
        Assertions.assertSame((Object)expected, result);
        ((Session)Mockito.verify((Object)session)).close();
        ((Batch)Mockito.verify((Object)batch)).close();
    }
}

