/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.session.cache.metadata.coarse.AbstractSessionMetaDataEntryTestCase;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataOffsetValues;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryFunction;
import org.wildfly.common.function.Functions;

public class SessionMetaDataEntryFunctionTestCase
extends AbstractSessionMetaDataEntryTestCase {
    @Override
    public void accept(ContextualSessionMetaDataEntry<Object> entry) {
        UUID context = UUID.randomUUID();
        Assertions.assertThat((Object)entry.getContext().get(Functions.constantSupplier((Object)context))).isSameAs((Object)context);
        Assertions.assertThat((Object)entry.getContext().get(Functions.constantSupplier(null))).isSameAs((Object)context);
        MutableSessionMetaDataOffsetValues delta = MutableSessionMetaDataOffsetValues.from(entry);
        MutableSessionMetaDataEntry mutableEntry = new MutableSessionMetaDataEntry(entry, delta);
        this.updateState((SessionMetaDataEntry)mutableEntry);
        this.verifyOriginalState((SessionMetaDataEntry)entry);
        Key key = (Key)Mockito.mock(Key.class);
        ContextualSessionMetaDataEntry resultEntry = (ContextualSessionMetaDataEntry)new SessionMetaDataEntryFunction(delta).apply((Object)key, entry);
        Mockito.verifyNoInteractions((Object[])new Object[]{key});
        this.verifyUpdatedState((SessionMetaDataEntry)resultEntry);
        Assertions.assertThat((Object)resultEntry.getContext().get(Functions.constantSupplier(null))).isSameAs((Object)context);
    }
}

