/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.CachedSessionManager;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;

public class CacheableSessionManagerTestCase {
    @Test
    public void findSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(expected2)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.findSession(id);){
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes1);
            try (Session session2 = subject.findSession(id);){
                Assertions.assertThat((Object)session2).isNotNull();
                Assertions.assertThat((Object)session2).isSameAs((Object)session1);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.findSession(id);){
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
        }
    }

    @Test
    public void findInvalidSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        Session expected1 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.findSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(null)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        try (Session session1 = subject.findSession(id);){
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes1);
            session1.invalidate();
            ((Session)Mockito.verify((Object)expected1)).invalidate();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
    }

    @Test
    public void createSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Mockito.when((Object)manager.createSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected1), (Object[])new CompletionStage[]{CompletableFuture.completedStage(expected2)});
        Mockito.when((Object)expected1.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected1.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected1.getAttributes()).thenReturn((Object)attributes1);
        Mockito.when((Object)expected1.getMetaData()).thenReturn((Object)metaData1);
        Mockito.when((Object)expected2.getId()).thenReturn((Object)id);
        Mockito.when((Object)expected2.isValid()).thenReturn((Object)true);
        Mockito.when((Object)expected2.getAttributes()).thenReturn((Object)attributes2);
        Mockito.when((Object)expected2.getMetaData()).thenReturn((Object)metaData2);
        try (Session session1 = subject.createSession(id);){
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes1);
            try (Session session2 = subject.findSession(id);){
                Assertions.assertThat((Object)session2).isNotNull();
                Assertions.assertThat((Object)session2).isSameAs((Object)session1);
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        try (Session session = subject.createSession(id);){
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
        }
    }

    @Test
    public void getIdentifierFactory() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)manager.getIdentifierFactory()).thenReturn((Object)expected);
        Supplier result = subject.getIdentifierFactory();
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }

    @Test
    public void start() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        subject.start();
        ((SessionManager)Mockito.verify((Object)manager)).start();
    }

    @Test
    public void stop() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        subject.stop();
        ((SessionManager)Mockito.verify((Object)manager)).stop();
    }

    @Test
    public void getStatistics() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionStatistics statistics = (SessionStatistics)Mockito.mock(SessionStatistics.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        Mockito.when((Object)manager.getStatistics()).thenReturn((Object)statistics);
        Assertions.assertThat((Object)subject.getStatistics()).isSameAs((Object)statistics);
    }

    @Test
    public void getBatcher() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)manager.getBatchFactory()).thenReturn((Object)expected);
        Supplier result = subject.getBatchFactory();
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }

    @Test
    public void findImmutableSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        ImmutableSession expected = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        String id = "foo";
        Mockito.when((Object)manager.findImmutableSessionAsync(id)).thenReturn(CompletableFuture.completedStage(expected));
        ImmutableSession result = subject.findImmutableSession(id);
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }
}

