/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;

public class MutableUserSessionsTestCase {
    @Test
    public void getApplications() {
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        MutableUserSessions sessions = new MutableUserSessions(Map.of("deployment", "session"), mutator);
        Set result = sessions.getDeployments();
        Assertions.assertThat((Collection)result).containsExactly((Object[])new String[]{"deployment"});
        ((CacheEntryMutator)Mockito.verify((Object)mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void getSession() {
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        MutableUserSessions sessions = new MutableUserSessions(Map.of("deployment", "session"), mutator);
        Assertions.assertThat((String)((String)sessions.getSession((Object)"deployment"))).isEqualTo("session");
        Assertions.assertThat((String)((String)sessions.getSession((Object)"foo"))).isNull();
        ((CacheEntryMutator)Mockito.verify((Object)mutator, (VerificationMode)Mockito.never())).mutate();
    }

    @Test
    public void addSession() {
        TreeMap deployments = new TreeMap();
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        MutableUserSessions sessions = new MutableUserSessions(deployments, mutator);
        sessions.addSession((Object)"deployment", (Object)"session");
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).mutate();
        sessions.addSession((Object)"deployment", (Object)"session");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
    }

    @Test
    public void removeSession() {
        TreeMap<String, String> deployments = new TreeMap<String, String>(Map.of("deployment", "session"));
        CacheEntryMutator mutator = (CacheEntryMutator)Mockito.mock(CacheEntryMutator.class);
        MutableUserSessions sessions = new MutableUserSessions(deployments, mutator);
        sessions.removeSession((Object)"deployment");
        ((CacheEntryMutator)Mockito.verify((Object)mutator)).mutate();
        sessions.removeSession((Object)"deployment");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
    }
}

