/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.coarse.CoarseSessionMetaDataSerializationContextInitializer;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaDataEntry;

public class DefaultSessionMetaDataEntryMarshallerTestCase {
    @Test
    public void test() {
        Tester tester = new ProtoStreamTesterFactory((SerializationContextInitializer)new CoarseSessionMetaDataSerializationContextInitializer()).createTester(DefaultSessionMetaDataEntryMarshallerTestCase::assertEquals);
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry(Instant.now());
        entry.setTimeout(Duration.ofMinutes(30L));
        entry.getLastAccessEndTime().setOffset(Offset.forInstant((Duration)Duration.ofSeconds(1L)));
        tester.accept(entry);
        Instant lastAccessStartTime = Instant.now();
        entry.getLastAccessStartTime().set((Object)lastAccessStartTime);
        entry.getLastAccessEndTime().set((Object)lastAccessStartTime.plus(Duration.ofSeconds(2L)));
        tester.accept(entry);
        entry.setTimeout(Duration.ofMinutes(10L));
        tester.accept(entry);
    }

    static void assertEquals(ContextualSessionMetaDataEntry<Object> entry1, ContextualSessionMetaDataEntry<Object> entry2) {
        Assertions.assertThat((long)((Instant)entry1.getLastAccessStartTime().getBasis()).toEpochMilli()).isEqualTo(((Instant)entry2.getLastAccessStartTime().getBasis()).toEpochMilli());
        Assertions.assertThat((Duration)entry2.getTimeout()).isEqualTo((Object)entry1.getTimeout());
        Assertions.assertThat((Instant)((Instant)entry2.getLastAccessStartTime().get())).isEqualTo(entry1.getLastAccessStartTime().get());
        Assertions.assertThat((Instant)((Instant)entry2.getLastAccessEndTime().get())).isEqualTo(entry1.getLastAccessEndTime().get());
    }
}

