/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.cache.CompositeSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;

public class CompositeSessionTestCase {
    private final String id = "session";
    private final InvalidatableSessionMetaData metaData = (InvalidatableSessionMetaData)Mockito.mock(InvalidatableSessionMetaData.class);
    private final SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
    private final CacheEntryRemover<String> remover = (CacheEntryRemover)Mockito.mock(CacheEntryRemover.class);
    private final Object context = new Object();
    private final Session<Object> session = new CompositeSession(this.id, this.metaData, this.attributes, Supplied.simple(), (Supplier)org.wildfly.clustering.function.Supplier.of((Object)this.context), this.remover);

    @Test
    public void getId() {
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)this.id);
    }

    @Test
    public void getAttributes() {
        Assertions.assertThat((Map)this.session.getAttributes()).isSameAs((Object)this.attributes);
    }

    @Test
    public void getMetaData() {
        Assertions.assertThat((Object)this.session.getMetaData()).isSameAs((Object)this.metaData);
    }

    @Test
    public void invalidate() {
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)true);
        this.session.invalidate();
        ((CacheEntryRemover)Mockito.verify(this.remover)).remove((Object)this.id);
        Mockito.reset((Object[])new CacheEntryRemover[]{this.remover});
        Mockito.when((Object)this.metaData.invalidate()).thenReturn((Object)false);
        this.session.invalidate();
        ((CacheEntryRemover)Mockito.verify(this.remover, (VerificationMode)Mockito.never())).remove((Object)this.id);
    }

    @Test
    public void isValid() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        Assertions.assertThat((boolean)this.session.isValid()).isTrue();
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        Assertions.assertThat((boolean)this.session.isValid()).isFalse();
    }

    @Test
    public void close() {
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)true);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes)).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData)).close();
        Mockito.reset((Object[])new AutoCloseable[]{this.metaData, this.attributes});
        Mockito.when((Object)this.metaData.isValid()).thenReturn((Object)false);
        this.session.close();
        ((SessionAttributes)Mockito.verify((Object)this.attributes, (VerificationMode)Mockito.never())).close();
        ((InvalidatableSessionMetaData)Mockito.verify((Object)this.metaData, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void getLocalContext() {
        Object result = this.session.getContext();
        Assertions.assertThat((Object)result).isSameAs(this.context);
    }
}

