/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;

public abstract class AbstractImmutableSessionMetaDataTestCase {
    void testCreationTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)expected).when((Object)entry)).getCreationTime();
        Instant result = metaData.getCreationTime();
        Assertions.assertThat((Instant)result).isSameAs((Object)expected);
    }

    void testLastAccessStartTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        OffsetValue lastAccessStartTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)false).when((Object)entry)).isNew();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessStartTime).when((Object)entry)).getLastAccessStartTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessStartTime)).get();
        Assertions.assertThat((Instant)metaData.getLastAccessStartTime()).isSameAs((Object)expected);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)true).when((Object)entry)).isNew();
        Assertions.assertThat((Instant)metaData.getLastAccessStartTime()).isNull();
    }

    void testLastAccessEndTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        OffsetValue lastAccessEndTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)false).when((Object)entry)).isNew();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessEndTime).when((Object)entry)).getLastAccessEndTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessEndTime)).get();
        Assertions.assertThat((Instant)metaData.getLastAccessEndTime()).isEqualTo((Object)expected);
        Assertions.assertThat((Instant)metaData.getLastAccessTime()).isEqualTo((Object)expected);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)true).when((Object)entry)).isNew();
        Assertions.assertThat((Instant)metaData.getLastAccessEndTime()).isNull();
    }

    void testTimeout(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Duration expected = Duration.ofMinutes(60L);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)expected).when((Object)entry)).getTimeout();
        Duration result = metaData.getTimeout();
        Assertions.assertThat((Duration)result).isSameAs((Object)expected);
    }
}

