/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;

public abstract class AbstractImmutableSessionMetaDataTestCase {
    void isNew(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Mockito.when((Object)accessMetaData.isNew()).thenReturn((Object)true);
        Assertions.assertThat((boolean)metaData.isNew()).isTrue();
        Mockito.when((Object)accessMetaData.isNew()).thenReturn((Object)false);
        Assertions.assertThat((boolean)metaData.isNew()).isFalse();
    }

    void isExpired(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)Instant.now().minus(Duration.ofMinutes(10L)));
        Mockito.when((Object)creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(10L));
        Mockito.when((Object)accessMetaData.getSinceCreationDuration()).thenReturn((Object)Duration.ofMinutes(5L));
        Mockito.when((Object)accessMetaData.getLastAccessDuration()).thenReturn((Object)Duration.ofSeconds(1L));
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        Mockito.when((Object)creationMetaData.getTimeout()).thenReturn((Object)Duration.ofMinutes(5L).minus(Duration.ofSeconds(1L, 1L)));
        Assertions.assertThat((boolean)metaData.isExpired()).isTrue();
        Mockito.when((Object)creationMetaData.getTimeout()).thenReturn((Object)Duration.ZERO);
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
    }

    void getCreationTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = metaData.getCreationTime();
        Assertions.assertThat((Instant)result).isSameAs((Object)expected);
    }

    void getLastAccessStartTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation));
        Mockito.when((Object)accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Instant result = metaData.getLastAccessStartTime();
        Assertions.assertThat((Instant)result).isEqualTo((Object)now);
    }

    void getLastAccessEndTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Duration lastAccess = Duration.ofSeconds(1L);
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)now.minus(sinceCreation).minus(lastAccess));
        Mockito.when((Object)accessMetaData.getSinceCreationDuration()).thenReturn((Object)sinceCreation);
        Mockito.when((Object)accessMetaData.getLastAccessDuration()).thenReturn((Object)lastAccess);
        Instant result = metaData.getLastAccessEndTime();
        Assertions.assertThat((Instant)result).isEqualTo((Object)now);
    }

    void getMaxInactiveInterval(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Duration expected = Duration.ofMinutes(30L);
        Mockito.when((Object)creationMetaData.getTimeout()).thenReturn((Object)expected);
        Duration result = metaData.getTimeout();
        Assertions.assertThat((Duration)result).isSameAs((Object)expected);
    }
}

