/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.FineSessionMetaDataSerializationContextInitializer;

public class DefaultSessionCreationMetaDataEntryMarshallerTestCase {
    @Test
    public void test() {
        Tester tester = new ProtoStreamTesterFactory((SerializationContextInitializer)new FineSessionMetaDataSerializationContextInitializer()).createTester(DefaultSessionCreationMetaDataEntryMarshallerTestCase::assertEquals);
        DefaultSessionCreationMetaDataEntry entry = new DefaultSessionCreationMetaDataEntry(Instant.now());
        entry.setTimeout(Duration.ofMinutes(30L));
        tester.accept(entry);
        entry.setTimeout(Duration.ofMinutes(10L));
        tester.accept(entry);
    }

    static void assertEquals(DefaultSessionCreationMetaDataEntry<Object> entry1, DefaultSessionCreationMetaDataEntry<Object> entry2) {
        Assertions.assertThat((long)entry2.getCreationTime().toEpochMilli()).isEqualTo(entry1.getCreationTime().toEpochMilli());
        Assertions.assertThat((Duration)entry2.getTimeout()).isEqualTo((Object)entry1.getTimeout());
    }
}

