/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.CachedSessionManager;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;

public class CachedSessionManagerTestCase {
    @Test
    public void findSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(CompletableFuture.completedStage(expected1), (Object[])new Object[]{CompletableFuture.completedStage(expected2)}).when((Object)manager)).findSessionAsync(id);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected1)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected1)).isValid();
        ((Session)Mockito.doReturn((Object)attributes1).when((Object)expected1)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData1).when((Object)expected1)).getMetaData();
        ((Session)Mockito.doReturn((Object)id).when((Object)expected2)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected2)).isValid();
        ((Session)Mockito.doReturn((Object)attributes2).when((Object)expected2)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData2).when((Object)expected2)).getMetaData();
        try (Session session1 = subject.findSession(id);){
            ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes1);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
            try (Session session2 = subject.findSession(id);){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
                Assertions.assertThat((Object)session2).isNotNull();
                Assertions.assertThat((Object)session2).isSameAs((Object)session1);
                Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        try (Session session = subject.findSession(id);){
            ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).findSessionAsync(id);
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected2)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture<Session> future1 = new CompletableFuture<Session>();
        CompletableFuture<Session> future2 = new CompletableFuture<Session>();
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(future1, (Object[])new Object[]{future2}).when((Object)manager)).findSessionAsync(id);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected1)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected1)).isValid();
        ((Session)Mockito.doReturn((Object)attributes1).when((Object)expected1)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData1).when((Object)expected1)).getMetaData();
        ((Session)Mockito.doReturn((Object)id).when((Object)expected2)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected2)).isValid();
        ((Session)Mockito.doReturn((Object)attributes2).when((Object)expected2)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData2).when((Object)expected2)).getMetaData();
        CompletionStage stage1 = subject.findSessionAsync(id);
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.findSessionAsync(id);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future1.complete(expected1);
        try (Session session = (Session)stage1.toCompletableFuture().join();){
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes1);
        }
        ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        session = (Session)stage2.toCompletableFuture().join();
        try {
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes1);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        CompletionStage stage = subject.findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future2.complete(expected2);
        try (Session session = (Session)stage.toCompletableFuture().join();){
            ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).findSessionAsync(id);
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected2)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findMissingSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        String id = "foo";
        ((SessionManager)Mockito.doReturn(CompletableFuture.completedStage(null)).when((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Object)subject.findSession(id)).isNull();
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        Assertions.assertThat((Object)subject.findSession(id)).isNull();
        ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findMissingSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        String id = "foo";
        ((SessionManager)Mockito.doReturn(future).when((Object)manager)).findSessionAsync(id);
        CompletionStage stage1 = subject.findSessionAsync(id);
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.findSessionAsync(id);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future.complete(null);
        Assertions.assertThat((CompletionStage)stage1).isCompletedWithValue(null);
        Assertions.assertThat((CompletionStage)stage2).isCompletedWithValue(null);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findInvalidSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        String id = "foo";
        Session expected = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(CompletableFuture.completedStage(expected)).when((Object)manager)).findSessionAsync(id);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected)).isValid();
        ((Session)Mockito.doReturn((Object)attributes).when((Object)expected)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData).when((Object)expected)).getMetaData();
        try (Session session1 = subject.findSession(id);){
            ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
            ((Session)Mockito.doReturn((Object)false).when((Object)expected)).isValid();
            Assertions.assertThat((Object)subject.findSession(id)).isNull();
            ((Session)Mockito.verify((Object)expected, (VerificationMode)Mockito.never())).close();
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        Assertions.assertThat((Object)subject.findSession(id)).isNull();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findInvalidSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture<Session> future = new CompletableFuture<Session>();
        String id = "foo";
        Session expected = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(future).when((Object)manager)).findSessionAsync(id);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected)).isValid();
        ((Session)Mockito.doReturn((Object)attributes).when((Object)expected)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData).when((Object)expected)).getMetaData();
        CompletionStage stage1 = subject.findSessionAsync(id);
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.findSessionAsync(id);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future.complete(expected);
        ((Session)Mockito.doReturn((Object)false).when((Object)expected)).isValid();
        try (Session session1 = (Session)stage1.toCompletableFuture().join();){
            Assertions.assertThat((boolean)session1.isValid()).isFalse();
            ((Session)Mockito.verify((Object)expected, (VerificationMode)Mockito.never())).close();
            try (Session session2 = (Session)stage2.toCompletableFuture().join();){
                Assertions.assertThat((boolean)session2.isValid()).isFalse();
                ((Session)Mockito.verify((Object)expected, (VerificationMode)Mockito.never())).close();
                Assertions.assertThat((CompletionStage)subject.findSessionAsync(id)).isCompletedWithValue(null);
                ((Session)Mockito.verify((Object)expected, (VerificationMode)Mockito.never())).close();
            }
            ((Session)Mockito.verify((Object)expected, (VerificationMode)Mockito.never())).close();
        }
        ((Session)Mockito.verify((Object)expected)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        Assertions.assertThat((CompletionStage)subject.findSessionAsync(id)).isCompletedWithValue(null);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findExceptionalSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        String id = "foo";
        ((SessionManager)Mockito.doReturn(CompletableFuture.failedFuture(new Exception())).when((Object)manager)).findSessionAsync(id);
        Assertions.assertThatThrownBy(() -> subject.findSession(id));
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        Assertions.assertThatThrownBy(() -> subject.findSession(id));
        ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void findExceptionalSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture future = new CompletableFuture();
        String id = "foo";
        ((SessionManager)Mockito.doReturn(future).when((Object)manager)).findSessionAsync(id);
        CompletionStage stage1 = subject.findSessionAsync(id);
        ((SessionManager)Mockito.verify((Object)manager)).findSessionAsync(id);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.findSessionAsync(id);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future.completeExceptionally(new Exception());
        Assertions.assertThat((CompletionStage)stage1).isCompletedExceptionally();
        Assertions.assertThat((CompletionStage)stage2).isCompletedExceptionally();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void createSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        Instant creationTime = Instant.now();
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(CompletableFuture.completedStage(expected1), (Object[])new Object[]{CompletableFuture.completedStage(expected2)}).when((Object)manager)).createSessionAsync(id, creationTime);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected1)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected1)).isValid();
        ((Session)Mockito.doReturn((Object)attributes1).when((Object)expected1)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData1).when((Object)expected1)).getMetaData();
        ((Session)Mockito.doReturn((Object)id).when((Object)expected2)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected2)).isValid();
        ((Session)Mockito.doReturn((Object)attributes2).when((Object)expected2)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData2).when((Object)expected2)).getMetaData();
        try (Session session1 = subject.createSession(id, creationTime);){
            ((SessionManager)Mockito.verify((Object)manager)).createSessionAsync(id, creationTime);
            Assertions.assertThat((Object)session1).isNotNull();
            Assertions.assertThat((String)session1.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session1.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session1.getAttributes()).isSameAs((Object)attributes1);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
            try (Session session2 = subject.findSession(id);){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
                Assertions.assertThat((Object)session2).isNotNull();
                Assertions.assertThat((Object)session2).isSameAs((Object)session1);
                Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
            }
            ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        try (Session session = subject.createSession(id, creationTime);){
            ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).createSessionAsync(id, creationTime);
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected2)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void createSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture<Session> future1 = new CompletableFuture<Session>();
        CompletableFuture<Session> future2 = new CompletableFuture<Session>();
        Session expected1 = (Session)Mockito.mock(Session.class);
        Session expected2 = (Session)Mockito.mock(Session.class);
        String id = "foo";
        Instant creationTime = Instant.now();
        SessionMetaData metaData1 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes1 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData metaData2 = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionAttributes attributes2 = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        ((SessionManager)Mockito.doReturn(future1, (Object[])new Object[]{future2}).when((Object)manager)).createSessionAsync(id, creationTime);
        ((Session)Mockito.doReturn((Object)id).when((Object)expected1)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected1)).isValid();
        ((Session)Mockito.doReturn((Object)attributes1).when((Object)expected1)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData1).when((Object)expected1)).getMetaData();
        ((Session)Mockito.doReturn((Object)id).when((Object)expected2)).getId();
        ((Session)Mockito.doReturn((Object)true).when((Object)expected2)).isValid();
        ((Session)Mockito.doReturn((Object)attributes2).when((Object)expected2)).getAttributes();
        ((Session)Mockito.doReturn((Object)metaData2).when((Object)expected2)).getMetaData();
        CompletionStage stage1 = subject.createSessionAsync(id, creationTime);
        ((SessionManager)Mockito.verify((Object)manager)).createSessionAsync(id, creationTime);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.createSessionAsync(id, creationTime);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future1.complete(expected1);
        try (Session session = (Session)stage1.toCompletableFuture().join();){
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes1);
        }
        ((Session)Mockito.verify((Object)expected1, (VerificationMode)Mockito.never())).close();
        session = (Session)stage2.toCompletableFuture().join();
        try {
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData1);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes1);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        ((Session)Mockito.verify((Object)expected1)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        CompletionStage stage = subject.createSessionAsync(id, creationTime);
        ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).createSessionAsync(id, creationTime);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future2.complete(expected2);
        try (Session session = (Session)stage.toCompletableFuture().join();){
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isSameAs((Object)id);
            Assertions.assertThat((Object)session.getMetaData()).isSameAs((Object)metaData2);
            Assertions.assertThat((Map)session.getAttributes()).isSameAs((Object)attributes2);
            Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        }
        ((Session)Mockito.verify((Object)expected2)).close();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void createExceptionalSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        String id = "foo";
        Instant creationTime = Instant.now();
        ((SessionManager)Mockito.doReturn(CompletableFuture.failedFuture(new Exception())).when((Object)manager)).createSessionAsync(id, creationTime);
        Assertions.assertThatThrownBy(() -> subject.createSession(id, creationTime));
        ((SessionManager)Mockito.verify((Object)manager)).createSessionAsync(id, creationTime);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
        Assertions.assertThatThrownBy(() -> subject.createSession(id, creationTime));
        ((SessionManager)Mockito.verify((Object)manager, (VerificationMode)Mockito.times((int)2))).createSessionAsync(id, creationTime);
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void createExceptionalSessionAsync() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.CONCURRENT);
        CompletableFuture future = new CompletableFuture();
        String id = "foo";
        Instant creationTime = Instant.now();
        ((SessionManager)Mockito.doReturn(future).when((Object)manager)).createSessionAsync(id, creationTime);
        CompletionStage stage1 = subject.createSessionAsync(id, creationTime);
        ((SessionManager)Mockito.verify((Object)manager)).createSessionAsync(id, creationTime);
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        CompletionStage stage2 = subject.createSessionAsync(id, creationTime);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{manager});
        Assertions.assertThat((Collection)subject.keySet()).containsExactly((Object[])new String[]{id});
        future.completeExceptionally(new Exception());
        Assertions.assertThat((CompletionStage)stage1).isCompletedExceptionally();
        Assertions.assertThat((CompletionStage)stage2).isCompletedExceptionally();
        Assertions.assertThat((Collection)subject.keySet()).isEmpty();
    }

    @Test
    public void getIdentifierFactory() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)expected).when((Object)manager)).getIdentifierFactory();
        Supplier result = subject.getIdentifierFactory();
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }

    @Test
    public void start() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        subject.start();
        ((SessionManager)Mockito.verify((Object)manager)).start();
    }

    @Test
    public void stop() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        subject.stop();
        ((SessionManager)Mockito.verify((Object)manager)).stop();
    }

    @Test
    public void getStatistics() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionStatistics statistics = (SessionStatistics)Mockito.mock(SessionStatistics.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        ((SessionManager)Mockito.doReturn((Object)statistics).when((Object)manager)).getStatistics();
        Assertions.assertThat((Object)subject.getStatistics()).isSameAs((Object)statistics);
    }

    @Test
    public void getBatcher() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        Supplier expected = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)expected).when((Object)manager)).getBatchFactory();
        Supplier result = subject.getBatchFactory();
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }

    @Test
    public void findImmutableSession() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        CachedSessionManager subject = new CachedSessionManager(manager, (CacheFactory)CacheStrategy.NONE);
        ImmutableSession expected = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        String id = "foo";
        ((SessionManager)Mockito.doReturn(CompletableFuture.completedStage(expected)).when((Object)manager)).findImmutableSessionAsync(id);
        ImmutableSession result = subject.findImmutableSession(id);
        Assertions.assertThat((Object)result).isSameAs((Object)expected);
    }
}

