/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.DetachedSession;

public class DetachedSessionTestCase {
    private final String id = UUID.randomUUID().toString();
    private final Object localContext = new Object();
    private final Random random = new Random();

    @Test
    public void getId() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            Assertions.assertThat((String)detached.getId()).isSameAs((Object)this.id);
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{batchFactory});
    }

    @Test
    public void isValid() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findImmutableSession(this.id);
            Assertions.assertThat((boolean)detached.isValid()).isFalse();
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findImmutableSession(this.id);
            Assertions.assertThat((boolean)detached.isValid()).isTrue();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void invalidate() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((Session)detached).invalidate());
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            detached.invalidate();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            ((Session)Mockito.verify((Object)session)).invalidate();
            ((Session)Mockito.verify((Object)session)).close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void isExpired() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SessionMetaData)detached.getMetaData()).isExpired());
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            boolean expected = this.random.nextBoolean();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).isExpired();
            Assertions.assertThat((boolean)detached.getMetaData().isExpired()).isEqualTo(expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            ((Session)Mockito.verify((Object)session)).close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
    }

    @Test
    public void getCreationTime() {
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = Supplier.of((Object)batch);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SessionMetaData)detached.getMetaData()).getCreationTime());
            ((Batch)Mockito.verify((Object)batch)).close();
            Mockito.reset((Object[])new Batch[]{batch});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            Instant expected = Instant.now();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            ((SessionMetaData)Mockito.doReturn((Object)expected).when((Object)metaData)).getCreationTime();
            Assertions.assertThat((Instant)detached.getMetaData().getCreationTime()).isSameAs((Object)expected);
            ((Batch)Mockito.verify((Object)batch)).close();
        }
    }

    @Test
    public void getLastAccessStartTime() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        Batch batch3 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2, batch3}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SessionMetaData)detached.getMetaData()).getLastAccessStartTime());
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            Instant expected = Instant.now();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            ((SessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(expected)}).when((Object)metaData)).getLastAccessStartTime();
            Assertions.assertThat((Optional)detached.getMetaData().getLastAccessStartTime()).isEmpty();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Assertions.assertThat((Optional)detached.getMetaData().getLastAccessStartTime()).hasValue((Object)expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)3))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
            ((Batch)Mockito.verify((Object)batch3)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch3});
    }

    @Test
    public void getLastAccessEndTime() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        Batch batch3 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2, batch3}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SessionMetaData)detached.getMetaData()).getLastAccessEndTime());
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            Instant expected = Instant.now();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            ((SessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(expected)}).when((Object)metaData)).getLastAccessEndTime();
            Assertions.assertThat((Optional)detached.getMetaData().getLastAccessEndTime()).isEmpty();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Assertions.assertThat((Optional)detached.getMetaData().getLastAccessEndTime()).hasValue((Object)expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)3))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
            ((Batch)Mockito.verify((Object)batch3)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch3});
    }

    @Test
    public void getMaxIdle() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        Batch batch3 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2, batch3}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SessionMetaData)detached.getMetaData()).getMaxIdle());
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            Duration expected = Duration.ZERO;
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            ((SessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(expected)}).when((Object)metaData)).getMaxIdle();
            Assertions.assertThat((Optional)detached.getMetaData().getMaxIdle()).isEmpty();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch3});
            Assertions.assertThat((Optional)detached.getMetaData().getMaxIdle()).hasValue((Object)expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)3))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
            ((Batch)Mockito.verify((Object)batch3)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch3});
    }

    @Test
    public void setLastAccess() {
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetachedSessionTestCase.lambda$setLastAccess$0((Session)detached));
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{batchFactory});
    }

    @Test
    public void setMaxIdle() {
        Duration duration = Duration.ofMinutes(this.random.nextInt(127) + 1);
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetachedSessionTestCase.lambda$setMaxIdle$0((Session)detached, duration));
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
            detached.getMetaData().setMaxIdle(duration);
            ((SessionMetaData)Mockito.verify((Object)metaData)).setMaxIdle(duration);
            ((Session)Mockito.verify((Object)session)).close();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void getAttributeNames() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(detached.getAttributes()::keySet);
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            Map attributes = (Map)Mockito.mock(Map.class);
            Set<String> expected = Collections.singleton("foo");
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
            ((Map)Mockito.doReturn(expected).when((Object)attributes)).keySet();
            Assertions.assertThat(detached.getAttributes().keySet()).isSameAs(expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void getAttribute() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            String attributeName = "foo";
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetachedSessionTestCase.lambda$getAttribute$0((Session)detached, attributeName));
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            Map attributes = (Map)Mockito.mock(Map.class);
            Object expected = new Object();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
            ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).get(attributeName);
            Assertions.assertThat(detached.getAttributes().get(attributeName)).isSameAs(expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void setAttribute() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            String attributeName = "foo";
            String attributeValue = "bar";
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetachedSessionTestCase.lambda$setAttribute$0((Session)detached, attributeName, attributeValue));
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            Map attributes = (Map)Mockito.mock(Map.class);
            Object expected = new Object();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
            ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).put(attributeName, attributeValue);
            Assertions.assertThat((Object)detached.getAttributes().put(attributeName, attributeValue)).isSameAs(expected);
            ((Session)Mockito.verify((Object)session)).close();
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    @Test
    public void removeAttribute() {
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier batchFactory = (Supplier)Mockito.mock(Supplier.class);
        ((SessionManager)Mockito.doReturn((Object)batchFactory).when((Object)manager)).getBatchFactory();
        ((Supplier)Mockito.doReturn((Object)batch1, (Object[])new Object[]{batch2}).when((Object)batchFactory)).get();
        try (DetachedSession detached = new DetachedSession(manager, this.id, this.localContext);){
            String attributeName = "foo";
            ((SessionManager)Mockito.doReturn(null).when((Object)manager)).findSession(this.id);
            Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> DetachedSessionTestCase.lambda$removeAttribute$0((Session)detached, attributeName));
            ((Supplier)Mockito.verify((Object)batchFactory)).get();
            ((Batch)Mockito.verify((Object)batch1)).close();
            Mockito.verifyNoInteractions((Object[])new Object[]{batch2});
            Session session = (Session)Mockito.mock(Session.class);
            Map attributes = (Map)Mockito.mock(Map.class);
            Object expected = new Object();
            ((SessionManager)Mockito.doReturn((Object)session).when((Object)manager)).findSession(this.id);
            ((Session)Mockito.doReturn((Object)attributes).when((Object)session)).getAttributes();
            ((Map)Mockito.doReturn((Object)expected).when((Object)attributes)).remove(attributeName);
            Assertions.assertThat(detached.getAttributes().remove(attributeName)).isSameAs(expected);
            ((Supplier)Mockito.verify((Object)batchFactory, (VerificationMode)Mockito.times((int)2))).get();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
            ((Batch)Mockito.verify((Object)batch2)).close();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch2});
    }

    private static /* synthetic */ void lambda$removeAttribute$0(Session detached, String attributeName) throws Throwable {
        detached.getAttributes().remove(attributeName);
    }

    private static /* synthetic */ void lambda$setAttribute$0(Session detached, String attributeName, Object attributeValue) throws Throwable {
        detached.getAttributes().put(attributeName, attributeValue);
    }

    private static /* synthetic */ void lambda$getAttribute$0(Session detached, String attributeName) throws Throwable {
        detached.getAttributes().get(attributeName);
    }

    private static /* synthetic */ void lambda$setMaxIdle$0(Session detached, Duration duration) throws Throwable {
        detached.getMetaData().setMaxIdle(duration);
    }

    private static /* synthetic */ void lambda$setLastAccess$0(Session detached) throws Throwable {
        detached.getMetaData().setLastAccess(Instant.now(), Instant.now());
    }
}

