/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.SessionManagerFactoryContextProvider;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.cache.SimpleImmutableSession;

public abstract class SessionManagerITCase<P extends SessionManagerParameters> {
    private static final Supplier<AtomicReference<String>> SESSION_CONTEXT_FACTORY = AtomicReference::new;
    private static final String DEPLOYMENT_CONTEXT = "deployment";
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private final SessionManagerFactoryContextProvider<P, String> factory;
    private final String threadGroupName = this.getClass().getSimpleName();

    protected SessionManagerITCase(SessionManagerFactoryContextProvider<P, String> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basic(P parameters) {
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory1Context = this.factory.createContext(parameters, "member1", SESSION_CONTEXT_FACTORY);){
            SessionManagerFactory factory1 = (SessionManagerFactory)factory1Context.get();
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory2Context = this.factory.createContext(parameters, "member2", SESSION_CONTEXT_FACTORY);){
                SessionManagerFactory factory2 = (SessionManagerFactory)factory2Context.get();
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                    UUID foo = UUID.randomUUID();
                    UUID bar = UUID.randomUUID();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.verifySession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    this.updateSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", MapEntry.of((Object)foo, null), "bar", Map.entry(bar, 0)));
                    for (int i = 1; i <= 20; i += 2) {
                        this.updateSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("bar", Map.entry(i - 1, i)));
                        this.updateSession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("bar", Map.entry(i, i + 1)));
                    }
                    this.invalidateSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                    Assertions.assertThat(expiredSessions).isEmpty();
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrent(P parameters) throws InterruptedException, ExecutionException {
        int threads = 10;
        int requests = 10;
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory1Context = this.factory.createContext(parameters, "member1", SESSION_CONTEXT_FACTORY);){
            SessionManagerFactory factory1 = (SessionManagerFactory)factory1Context.get();
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory2Context = this.factory.createContext(parameters, "member2", SESSION_CONTEXT_FACTORY);){
                SessionManagerFactory factory2 = (SessionManagerFactory)factory2Context.get();
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    AtomicInteger value = new AtomicInteger();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("value", value));
                    ArrayList<Runnable> tasks = new ArrayList<Runnable>(threads);
                    for (int i = 0; i < threads; ++i) {
                        tasks.add(() -> {
                            for (int j = 0; j < requests; ++j) {
                                this.requestSession((SessionManager<AtomicReference<String>>)manager1, sessionId, session -> {
                                    AtomicInteger v = (AtomicInteger)session.getAttributes().get("value");
                                    Assertions.assertThat((AtomicInteger)v).isNotNull();
                                    v.incrementAndGet();
                                });
                            }
                        });
                    }
                    ArrayList futures = new ArrayList(threads);
                    ExecutorService executor = Executors.newFixedThreadPool(threads, (ThreadFactory)new DefaultThreadFactory(new ThreadGroup(this.threadGroupName), Thread.currentThread().getContextClassLoader()));
                    try {
                        Instant start = Instant.now();
                        for (Runnable runnable : tasks) {
                            futures.add(executor.submit(runnable));
                        }
                        for (Future future : futures) {
                            future.get();
                        }
                        Instant stop = Instant.now();
                        Duration duration = Duration.between(start, stop);
                        this.logger.log(System.Logger.Level.INFO, "{0} concurrent requests completed in {1}", threads * requests, duration);
                        this.requestSession((SessionManager<AtomicReference<String>>)manager2, sessionId, session -> Assertions.assertThat((AtomicInteger)((AtomicInteger)session.getAttributes().get("value"))).hasValue(threads * requests));
                        start = Instant.now();
                        for (int i = 0; i < threads; ++i) {
                            for (int j = 0; j < requests; ++j) {
                                this.requestSession((SessionManager<AtomicReference<String>>)manager1, sessionId, session -> {
                                    AtomicInteger v = (AtomicInteger)session.getAttributes().get("value");
                                    Assertions.assertThat((AtomicInteger)v).isNotNull();
                                    v.incrementAndGet();
                                });
                            }
                        }
                        stop = Instant.now();
                        Duration serialDuration = Duration.between(start, stop);
                        this.logger.log(System.Logger.Level.INFO, "{0} serial requests completed in {1}", threads * requests, serialDuration);
                        this.requestSession((SessionManager<AtomicReference<String>>)manager2, sessionId, session -> Assertions.assertThat((AtomicInteger)((AtomicInteger)session.getAttributes().get("value"))).hasValue(threads * requests * 2));
                        Assertions.assertThat((Duration)duration).isLessThan((Comparable)serialDuration);
                    }
                    finally {
                        executor.shutdown();
                    }
                    this.invalidateSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expiration(P parameters) throws InterruptedException {
        Duration expirationDuration = Duration.ofSeconds(120L);
        LinkedBlockingQueue<ImmutableSession> expiredSessions = new LinkedBlockingQueue<ImmutableSession>();
        TestSessionManagerConfiguration<String> managerConfig1 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        TestSessionManagerConfiguration<String> managerConfig2 = new TestSessionManagerConfiguration<String>(expiredSessions, DEPLOYMENT_CONTEXT);
        try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory1Context = this.factory.createContext(parameters, "member1", SESSION_CONTEXT_FACTORY);){
            SessionManagerFactory factory1 = (SessionManagerFactory)factory1Context.get();
            SessionManager manager1 = factory1.createSessionManager(managerConfig1);
            manager1.start();
            try (Context<SessionManagerFactory<String, AtomicReference<String>>> factory2Context = this.factory.createContext(parameters, "member2", SESSION_CONTEXT_FACTORY);){
                SessionManagerFactory factory2 = (SessionManagerFactory)factory2Context.get();
                SessionManager manager2 = factory2.createSessionManager(managerConfig2);
                manager2.start();
                try {
                    String sessionId = (String)manager1.getIdentifierFactory().get();
                    UUID foo = UUID.randomUUID();
                    UUID bar = UUID.randomUUID();
                    this.createSession((SessionManager<AtomicReference<String>>)manager1, sessionId, Map.of("foo", foo, "bar", bar));
                    this.requestSession((SessionManager<AtomicReference<String>>)manager1, sessionId, session -> session.getMetaData().setMaxIdle(Duration.ofSeconds(2L)));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    TimeUnit.SECONDS.sleep(1L);
                    this.verifySession((SessionManager<AtomicReference<String>>)manager2, sessionId, Map.of("foo", foo, "bar", bar));
                    try {
                        Instant start = Instant.now();
                        ImmutableSession expiredSession = (ImmutableSession)expiredSessions.poll(expirationDuration.getSeconds(), TimeUnit.SECONDS);
                        ((ObjectAssert)Assertions.assertThat((Object)expiredSession).as("No expiration event received within %s seconds", new Object[]{expirationDuration.getSeconds()})).isNotNull();
                        this.logger.log(System.Logger.Level.INFO, "Received expiration event for {0} after {1}", expiredSession.getId(), Duration.between(start, Instant.now()));
                        Assertions.assertThat((String)sessionId).isEqualTo(expiredSession.getId());
                        Assertions.assertThat((boolean)expiredSession.isValid()).isFalse();
                        Assertions.assertThat((Optional)expiredSession.getMetaData().getLastAccessTime()).isPresent();
                        Assertions.assertThat((boolean)expiredSession.getMetaData().isExpired()).isTrue();
                        Assertions.assertThat((Optional)expiredSession.getMetaData().getMaxIdle()).isPresent();
                        SessionManagerITCase.verifySessionAttributes(expiredSession, Map.of("foo", foo, "bar", bar));
                        Assertions.assertThat(expiredSessions).isEmpty();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager1, sessionId);
                    this.verifyNoSession((SessionManager<AtomicReference<String>>)manager2, sessionId);
                }
                finally {
                    manager2.stop();
                }
            }
            finally {
                manager1.stop();
            }
        }
    }

    private void createSession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Object> attributes) {
        this.requestSession(manager, arg_0 -> manager.createSession(arg_0), sessionId, session -> {
            Assertions.assertThat((Optional)session.getMetaData().getLastAccessTime()).isEmpty();
            SessionManagerITCase.verifySessionMetaData((Session<AtomicReference<String>>)session);
            SessionManagerITCase.verifySessionAttributes((ImmutableSession)session, Map.of());
            SessionManagerITCase.updateSessionAttributes((Session<AtomicReference<String>>)session, attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AbstractMap.SimpleEntry(null, entry.getValue()))));
            SessionManagerITCase.verifySessionAttributes((ImmutableSession)session, attributes);
        });
    }

    private void verifySession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Object> attributes) {
        this.requestSession(manager, sessionId, session -> {
            Assertions.assertThat((Optional)session.getMetaData().getLastAccessTime()).isPresent();
            SessionManagerITCase.verifySessionMetaData((Session<AtomicReference<String>>)session);
            SessionManagerITCase.verifySessionAttributes((ImmutableSession)session, attributes);
        });
    }

    private void updateSession(SessionManager<AtomicReference<String>> manager, String sessionId, Map<String, Map.Entry<Object, Object>> attributes) {
        this.requestSession(manager, sessionId, session -> {
            Assertions.assertThat((Object)session).isNotNull();
            Assertions.assertThat((String)session.getId()).isEqualTo(sessionId);
            Assertions.assertThat((Optional)session.getMetaData().getLastAccessTime()).isPresent();
            SessionManagerITCase.verifySessionMetaData((Session<AtomicReference<String>>)session);
            SessionManagerITCase.updateSessionAttributes((Session<AtomicReference<String>>)session, attributes);
        });
    }

    private void invalidateSession(SessionManager<AtomicReference<String>> manager, String sessionId) {
        this.requestSession(manager, sessionId, session -> {
            session.invalidate();
            Assertions.assertThat((boolean)session.isValid()).isFalse();
            Assertions.assertThatThrownBy(() -> session.getAttributes()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> session.getMetaData()).isInstanceOf(IllegalStateException.class);
        });
    }

    private void requestSession(SessionManager<AtomicReference<String>> manager, String sessionId, java.util.function.Consumer<Session<AtomicReference<String>>> action) {
        this.requestSession(manager, arg_0 -> manager.findSession(arg_0), sessionId, action);
    }

    private void requestSession(SessionManager<AtomicReference<String>> manager, Function<String, Session<AtomicReference<String>>> sessionFactory, String sessionId, java.util.function.Consumer<Session<AtomicReference<String>>> action) {
        Instant start = Instant.now();
        try (Batch batch = (Batch)manager.getBatchFactory().get();){
            try (Session<AtomicReference<String>> session = sessionFactory.apply(sessionId);){
                Assertions.assertThat(session).isNotNull();
                Assertions.assertThat((String)session.getId()).isEqualTo(sessionId);
                action.accept(session);
                if (session.isValid()) {
                    SessionMetaData metaData = session.getMetaData();
                    Instant end = Instant.now();
                    metaData.setLastAccess(start, end);
                    Assertions.assertThat((Optional)session.getMetaData().getLastAccessTime()).isPresent();
                    Assertions.assertThat((Optional)session.getMetaData().getLastAccessStartTime()).isPresent();
                    Assertions.assertThat((Optional)session.getMetaData().getLastAccessEndTime()).isPresent();
                    if (!Thread.currentThread().getThreadGroup().getName().equals(this.threadGroupName)) {
                        if (metaData.getLastAccessStartTime().isPresent()) {
                            Assertions.assertThat((long)Duration.between((Temporal)metaData.getLastAccessStartTime().get(), start).getSeconds()).isEqualTo(0L);
                            Assertions.assertThat((int)Duration.between((Temporal)metaData.getLastAccessStartTime().get(), start).truncatedTo(ChronoUnit.MILLIS).getNano()).isEqualTo(0);
                        }
                        if (metaData.getLastAccessEndTime().isPresent()) {
                            Assertions.assertThat((long)Duration.between(end, (Temporal)metaData.getLastAccessEndTime().get()).getSeconds()).isEqualTo(0L);
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                this.logger.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                batch.discard();
                throw e;
            }
        }
    }

    private static void verifySessionMetaData(Session<AtomicReference<String>> session) {
        Assertions.assertThat((boolean)session.isValid()).isTrue();
        SessionMetaData metaData = session.getMetaData();
        Assertions.assertThat((Optional)metaData.getMaxIdle()).isPresent();
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        if (metaData.getLastAccessTime().isPresent()) {
            if (((Instant)metaData.getLastAccessStartTime().get()).isBefore(metaData.getCreationTime())) {
                Assertions.assertThat((long)Duration.between((Temporal)metaData.getLastAccessStartTime().get(), metaData.getCreationTime()).getSeconds()).isEqualTo(0L);
            }
            Assertions.assertThat((Instant)((Instant)metaData.getLastAccessStartTime().get())).isBefore((Instant)metaData.getLastAccessEndTime().get());
        }
    }

    private static void verifySessionAttributes(ImmutableSession session, Map<String, Object> attributes) {
        Assertions.assertThat(session.getAttributes().keySet()).containsAll(attributes.keySet());
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Assertions.assertThat(session.getAttributes().get(entry.getKey())).isEqualTo(entry.getValue());
        }
    }

    private static void updateSessionAttributes(Session<AtomicReference<String>> session, Map<String, Map.Entry<Object, Object>> attributes) {
        for (Map.Entry<String, Map.Entry<Object, Object>> entry : attributes.entrySet()) {
            String name = entry.getKey();
            Object expected = entry.getValue().getKey();
            Object value = entry.getValue().getValue();
            if (value != null) {
                Assertions.assertThat((Object)session.getAttributes().put(name, value)).isEqualTo(expected);
                continue;
            }
            Assertions.assertThat(session.getAttributes().remove(name)).isEqualTo(expected);
        }
    }

    private void verifyNoSession(SessionManager<AtomicReference<String>> manager, String sessionId) {
        try (Batch batch = (Batch)manager.getBatchFactory().get();){
            try (Session session = manager.findSession(sessionId);){
                Assertions.assertThat((Object)session).isNull();
            }
            catch (RuntimeException e) {
                this.logger.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                batch.discard();
                throw e;
            }
        }
    }

    private static class TestSessionManagerConfiguration<C>
    implements SessionManagerConfiguration<C> {
        private final java.util.function.Consumer<ImmutableSession> expirationListener;
        private final C context;

        TestSessionManagerConfiguration(BlockingQueue<ImmutableSession> expired, C context) {
            Consumer queue = expired::add;
            this.expirationListener = queue.compose(SimpleImmutableSession::new);
            this.context = context;
        }

        public Supplier<String> getIdentifierFactory() {
            return () -> UUID.randomUUID().toString();
        }

        public java.util.function.Consumer<ImmutableSession> getExpirationListener() {
            return this.expirationListener;
        }

        public Optional<Duration> getMaxIdle() {
            return Optional.of(Duration.ofMinutes(1L));
        }

        public C getContext() {
            return this.context;
        }
    }
}

