/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.container.ContainerProvider;

public class ImmutableSessionActivationNotifierTestCase {
    @Test
    public void test() {
        ContainerProvider provider = (ContainerProvider)Mockito.mock(ContainerProvider.class);
        Session session = (Session)Mockito.mock(Session.class);
        Listener listener1 = (Listener)Mockito.mock(Listener.class);
        Listener listener2 = (Listener)Mockito.mock(Listener.class);
        List<Listener> attributes = List.of(UUID.randomUUID(), listener1, listener2);
        ImmutableSessionActivationNotifier notifier = new ImmutableSessionActivationNotifier(provider, (Object)session, attributes);
        ((ContainerProvider)Mockito.doReturn(Optional.empty()).when((Object)provider)).getSessionEventListener((Object)((Session)Mockito.same((Object)session)), Mockito.any(UUID.class));
        ((ContainerProvider)Mockito.doReturn(Optional.of(listener1)).when((Object)provider)).getSessionEventListener((Object)((Session)Mockito.same((Object)session)), Mockito.same((Object)listener1));
        ((ContainerProvider)Mockito.doReturn(Optional.of(listener2)).when((Object)provider)).getSessionEventListener((Object)((Session)Mockito.same((Object)session)), Mockito.same((Object)listener2));
        Consumer prePassivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer prePassivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivateNotifier2 = (Consumer)Mockito.mock(Consumer.class);
        ((ContainerProvider)Mockito.doReturn((Object)prePassivateNotifier1).when((Object)provider)).getPrePassivateEventNotifier((Object)listener1);
        ((ContainerProvider)Mockito.doReturn((Object)prePassivateNotifier2).when((Object)provider)).getPrePassivateEventNotifier((Object)listener2);
        ((ContainerProvider)Mockito.doReturn((Object)postActivateNotifier1).when((Object)provider)).getPostActivateEventNotifier((Object)listener1);
        ((ContainerProvider)Mockito.doReturn((Object)postActivateNotifier2).when((Object)provider)).getPostActivateEventNotifier((Object)listener2);
        notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept((Object)session);
        Mockito.reset((Object[])new Consumer[]{postActivateNotifier1, postActivateNotifier2});
        notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1)).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2)).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        Mockito.reset((Object[])new Consumer[]{prePassivateNotifier1, prePassivateNotifier2});
        notifier.prePassivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        notifier.postActivate();
        ((Consumer)Mockito.verify((Object)prePassivateNotifier1, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)prePassivateNotifier2, (VerificationMode)Mockito.never())).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier1)).accept((Object)session);
        ((Consumer)Mockito.verify((Object)postActivateNotifier2)).accept((Object)session);
    }

    static interface Session {
    }

    static interface Listener {
    }

    static interface Context {
    }
}

