/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;

public abstract class AbstractSessionCreationMetaDataEntryTestCase
implements Consumer<SessionCreationMetaDataEntry<Object>> {
    private final Instant created = Instant.now();
    private final Duration originalTimeout = Duration.ofMinutes(20L);
    private final Duration timeoutDelta = Duration.ofMinutes(10L);
    private final Duration updatedTimeout = this.originalTimeout.plus(this.timeoutDelta);

    @Test
    public void test() {
        DefaultSessionCreationMetaDataEntry entry = new DefaultSessionCreationMetaDataEntry(this.created);
        Assertions.assertThat((Instant)entry.getCreationTime()).isEqualTo((Object)this.created);
        Assertions.assertThat((Duration)entry.getMaxIdle()).isZero();
        Assertions.assertThat((Object)entry.getContext().get(() -> null)).isNull();
        entry.setMaxIdle(this.originalTimeout);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        SessionCreationMetaDataEntry remapped = entry.remap(() -> Offset.forDuration((Duration)this.timeoutDelta));
        this.verifyUpdatedState((SessionCreationMetaData)remapped);
        this.verifyOriginalState((SessionCreationMetaData)entry);
        this.accept(entry);
    }

    void updateState(SessionCreationMetaData metaData) {
        metaData.setMaxIdle(this.updatedTimeout);
    }

    void verifyOriginalState(SessionCreationMetaData metaData) {
        Assertions.assertThat((Instant)metaData.getCreationTime()).isEqualTo((Object)this.created);
        Assertions.assertThat((Duration)metaData.getMaxIdle()).isEqualTo((Object)this.originalTimeout);
    }

    void verifyUpdatedState(SessionCreationMetaData metaData) {
        Assertions.assertThat((Instant)metaData.getCreationTime()).isEqualTo((Object)this.created);
        Assertions.assertThat((Duration)metaData.getMaxIdle()).isEqualTo((Object)this.updatedTimeout);
    }
}

