/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.session.cache.user.CompositeUser;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;

public class CompositeUserTestCase {
    private final String id = "id";
    private final UserSessions<String, String> sessions = (UserSessions)Mockito.mock(UserSessions.class);
    private final String context = "context";
    private final String localContext = "local-context";
    private final CacheEntryRemover<String> remover = (CacheEntryRemover)Mockito.mock(CacheEntryRemover.class);
    private final User<String, Object, String, String> user = new CompositeUser(this.id, Map.entry(this.context, this.localContext), this.sessions, this.remover);

    @Test
    public void getId() {
        Assertions.assertThat((String)this.user.getId()).isSameAs((Object)this.id);
    }

    @Test
    public void getContext() {
        Assertions.assertThat((String)((String)this.user.getPersistentContext())).isSameAs((Object)this.context);
    }

    @Test
    public void getSessions() {
        Assertions.assertThat((Object)this.user.getSessions()).isSameAs(this.sessions);
    }

    @Test
    public void invalidate() {
        this.user.invalidate();
        ((CacheEntryRemover)Mockito.verify(this.remover)).remove((Object)this.id);
    }

    @Test
    public void getLocalContext() {
        Assertions.assertThat((Object)this.user.getTransientContext()).isSameAs((Object)this.localContext);
    }
}

