/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Runner;
import org.wildfly.clustering.function.UnaryOperator;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.CacheableSession;
import org.wildfly.clustering.session.cache.CachedSession;
import org.wildfly.clustering.session.cache.DecoratedSessionManager;

public class CachedSessionManager<C>
extends DecoratedSessionManager<C> {
    static final System.Logger LOGGER = System.getLogger(CachedSessionManager.class.getName());
    private final Cache<String, CompletionStage<CacheableSession<C>>> sessionCache;
    private final BiFunction<String, Instant, CompletionStage<Session<C>>> sessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> defaultSessionCreator;
    private final BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>> sessionFinder;
    private final UnaryOperator<Session<C>> validator = new UnaryOperator<Session<C>>(){

        public Session<C> apply(Session<C> session) {
            if (!session.isValid()) {
                session.close();
                return null;
            }
            return session;
        }
    };

    public CachedSessionManager(SessionManager<C> manager, CacheFactory cacheFactory) {
        super(manager);
        this.sessionCreator = (arg_0, arg_1) -> manager.createSessionAsync(arg_0, arg_1);
        this.defaultSessionCreator = new SessionManagerFunction(arg_0 -> manager.createSessionAsync(arg_0));
        this.sessionFinder = new SessionManagerFunction(arg_0 -> manager.findSessionAsync(arg_0));
        this.sessionCache = cacheFactory.createCache((java.util.function.Consumer)Consumer.empty(), (java.util.function.Consumer)new Consumer<CompletionStage<CacheableSession<C>>>(){

            public void accept(CompletionStage<CacheableSession<C>> stage) {
                try {
                    Optional.ofNullable(stage.toCompletableFuture().join()).map(Supplier::get).ifPresent(Session::close);
                }
                catch (CancellationException | CompletionException e) {
                    LOGGER.log(System.Logger.Level.DEBUG, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }

    public CompletionStage<Session<C>> createSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.defaultSessionCreator)).thenApply(this.validator);
    }

    @Override
    public CompletionStage<Session<C>> createSessionAsync(String id, Instant creationTime) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, new SessionManagerFunction(this.sessionCreator.composeUnary((Function)UnaryOperator.identity(), (Function)org.wildfly.clustering.function.Function.of((Object)creationTime))))).thenApply(this.validator);
    }

    @Override
    public CompletionStage<Session<C>> findSessionAsync(String id) {
        return ((CompletionStage)this.sessionCache.computeIfAbsent((Object)id, this.sessionFinder)).thenApply(this.validator);
    }

    Set<String> keySet() {
        return this.sessionCache.keySet();
    }

    static class SessionManagerFunction<C>
    implements BiFunction<String, Runnable, CompletionStage<CacheableSession<C>>>,
    Session<C> {
        private final org.wildfly.clustering.function.Function<String, CompletionStage<Session<C>>> operation;

        SessionManagerFunction(org.wildfly.clustering.function.Function<String, CompletionStage<Session<C>>> operation) {
            this.operation = operation;
        }

        public CompletionStage<CacheableSession<C>> apply(String id, Runnable closeTask) {
            return ((CompletionStage)this.operation.apply((Object)id)).handle((session, exception) -> new CachedSession(session != null ? session : this, (Runnable)(exception != null ? Runner.throwing((Supplier)org.wildfly.clustering.function.Supplier.of((Object)new CompletionException((Throwable)exception))).compose(closeTask) : closeTask)));
        }

        public String getId() {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public Map<String, Object> getAttributes() {
            return Map.of();
        }

        public SessionMetaData getMetaData() {
            return null;
        }

        public void invalidate() {
        }

        public C getContext() {
            return null;
        }

        public void close() {
        }
    }
}

